/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.cache;

import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.TenantAwareKey;
import io.ebean.meta.MetricVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class TenantAwareCache
implements ServerCache {
    private final ServerCache delegate;
    private final TenantAwareKey tenantAwareKey;

    public TenantAwareCache(ServerCache delegate, TenantAwareKey tenantAwareKey) {
        this.delegate = delegate;
        this.tenantAwareKey = tenantAwareKey;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        return (T)this.delegate;
    }

    @Override
    public void visit(MetricVisitor visitor) {
        this.delegate.visit(visitor);
    }

    private Object key(Object key) {
        return this.tenantAwareKey.key(key);
    }

    @Override
    public Object get(Object id) {
        return this.delegate.get(this.key(id));
    }

    @Override
    public void put(Object id, Object value) {
        this.delegate.put(this.key(id), value);
    }

    @Override
    public void remove(Object id) {
        this.delegate.remove(this.key(id));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public int hitRatio() {
        return this.delegate.hitRatio();
    }

    @Override
    public ServerCacheStatistics statistics(boolean reset) {
        return this.delegate.statistics(reset);
    }

    @Override
    public Map<Object, Object> getAll(Set<Object> keys) {
        HashMap keyMapping = new HashMap(keys.size());
        keys.forEach(k -> keyMapping.put(this.key(k), k));
        Map<Object, Object> tmp = this.delegate.getAll(keyMapping.keySet());
        HashMap<Object, Object> ret = new HashMap<Object, Object>(keys.size());
        tmp.forEach((k, v) -> ret.put(((TenantAwareKey.CacheKey)k).key, v));
        return ret;
    }

    @Override
    public void putAll(Map<Object, Object> keyValues) {
        HashMap<Object, Object> tmp = new HashMap<Object, Object>();
        keyValues.forEach((k, v) -> tmp.put(this.key(k), v));
        this.delegate.putAll(tmp);
    }

    @Override
    public void removeAll(Set<Object> keys) {
        this.delegate.removeAll(keys.stream().map(this::key).collect(Collectors.toSet()));
    }
}

