/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.avaje.lang.NonNullApi;
import io.avaje.lang.Nullable;
import io.ebean.DB;
import io.ebean.Database;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import java.util.List;

@NonNullApi
public class Finder<I, T> {
    private final Class<T> type;
    private final String _$dbName;

    public Finder(Class<T> type) {
        this.type = type;
        this._$dbName = null;
    }

    public Finder(Class<T> type, String databaseName) {
        this.type = type;
        this._$dbName = databaseName;
    }

    public Transaction currentTransaction() {
        return this.db().currentTransaction();
    }

    public void flush() {
        this.db().flush();
    }

    public Database db() {
        return DB.byName(this._$dbName);
    }

    public Database db(String databaseName) {
        return DB.byName(databaseName);
    }

    public T ref(I id) {
        return this.db().reference(this.type, id);
    }

    @Nullable
    public T byId(I id) {
        return this.db().find(this.type, id);
    }

    public void deleteById(I id) {
        this.db().delete(this.type, id);
    }

    public List<T> all() {
        return this.query().findList();
    }

    public UpdateQuery<T> update() {
        return this.db().update(this.type);
    }

    public Query<T> query() {
        return this.db().find(this.type);
    }

    public Query<T> nativeSql(String nativeSql) {
        return this.db().findNative(this.type, nativeSql);
    }

    public Query<T> query(String ormQuery) {
        return this.db().createQuery(this.type, ormQuery);
    }
}

