/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import io.druid.segment.IndexIO;
import io.druid.segment.MetricColumnSerializer;
import io.druid.segment.MetricHolder;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.serde.ComplexMetricSerde;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ComplexMetricColumnSerializer
implements MetricColumnSerializer {
    private final String metricName;
    private final ComplexMetricSerde serde;
    private final IOPeon ioPeon;
    private final File outDir;
    private GenericIndexedWriter writer;

    public ComplexMetricColumnSerializer(String metricName, File outDir, IOPeon ioPeon, ComplexMetricSerde serde) {
        this.metricName = metricName;
        this.serde = serde;
        this.ioPeon = ioPeon;
        this.outDir = outDir;
    }

    @Override
    public void open() throws IOException {
        this.writer = new GenericIndexedWriter(this.ioPeon, String.format("%s_%s", this.metricName, this.outDir.getName()), this.serde.getObjectStrategy());
        this.writer.open();
    }

    @Override
    public void serialize(Object agg) throws IOException {
        this.writer.write(agg);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        File outFile = IndexIO.makeMetricFile(this.outDir, this.metricName, IndexIO.BYTE_ORDER);
        outFile.delete();
        MetricHolder.writeComplexMetric((OutputSupplier<? extends OutputStream>)Files.newOutputStreamSupplier((File)outFile, (boolean)true), this.metricName, this.serde.getTypeName(), this.writer);
        IndexIO.checkFileSize(outFile);
        this.writer = null;
    }
}

