/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.serde.ComplexMetricSerde;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class ComplexColumnSerializer
implements GenericColumnSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ComplexMetricSerde serde;
    private GenericIndexedWriter writer;

    public static ComplexColumnSerializer create(IOPeon ioPeon, String filenameBase, ComplexMetricSerde serde) {
        return new ComplexColumnSerializer(ioPeon, filenameBase, serde);
    }

    public ComplexColumnSerializer(IOPeon ioPeon, String filenameBase, ComplexMetricSerde serde) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.serde = serde;
    }

    @Override
    public void open() throws IOException {
        this.writer = new GenericIndexedWriter(this.ioPeon, String.format("%s.complex_column", this.filenameBase), this.serde.getObjectStrategy());
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        this.writer.write(obj);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public long getSerializedSize() {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        this.writer.writeToChannel(channel);
    }
}

