/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.logger.Logger;
import com.metamx.common.parsers.ParseException;
import io.druid.data.input.InputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;

public class OnheapIncrementalIndex
extends IncrementalIndex<Aggregator> {
    private static final Logger log = new Logger(OnheapIncrementalIndex.class);
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final ConcurrentMap<IncrementalIndex.TimeAndDims, Integer> facts;
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    protected final int maxRowCount;
    private volatile Map<String, ColumnSelectorFactory> selectors;
    private String outOfRowsReason = null;

    public OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean sortFacts, int maxRowCount) {
        super(incrementalIndexSchema, deserializeComplexMetrics, reportParseExceptions, sortFacts);
        this.maxRowCount = maxRowCount;
        this.facts = sortFacts ? new ConcurrentSkipListMap<IncrementalIndex.TimeAndDims, Integer>(this.dimsComparator()) : new ConcurrentHashMap<IncrementalIndex.TimeAndDims, Integer>();
    }

    public OnheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean sortFacts, int maxRowCount) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).build(), deserializeComplexMetrics, reportParseExceptions, sortFacts, maxRowCount);
    }

    public OnheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, int maxRowCount) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).build(), true, true, true, maxRowCount);
    }

    public OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean reportParseExceptions, int maxRowCount) {
        this(incrementalIndexSchema, true, reportParseExceptions, true, maxRowCount);
    }

    @Override
    public ConcurrentMap<IncrementalIndex.TimeAndDims, Integer> getFacts() {
        return this.facts;
    }

    @Override
    protected IncrementalIndex.DimDim makeDimDim(String dimension, Object lock) {
        return new OnHeapDimDim(lock);
    }

    protected Aggregator[] initAggs(AggregatorFactory[] metrics, Supplier<InputRow> rowSupplier, boolean deserializeComplexMetrics) {
        this.selectors = Maps.newHashMap();
        for (AggregatorFactory agg : metrics) {
            this.selectors.put(agg.getName(), new ObjectCachingColumnSelectorFactory(OnheapIncrementalIndex.makeColumnSelectorFactory(agg, rowSupplier, deserializeComplexMetrics)));
        }
        return new Aggregator[metrics.length];
    }

    @Override
    protected Integer addToFacts(AggregatorFactory[] metrics, boolean deserializeComplexMetrics, boolean reportParseExceptions, InputRow row, AtomicInteger numEntries, IncrementalIndex.TimeAndDims key, ThreadLocal<InputRow> rowContainer, Supplier<InputRow> rowSupplier) throws IndexSizeExceededException {
        Integer priorIndex = (Integer)this.facts.get(key);
        if (null != priorIndex) {
            Aggregator[] aggs = this.concurrentGet(priorIndex);
            this.doAggregate(aggs, rowContainer, row, reportParseExceptions);
        } else {
            Aggregator[] aggs = new Aggregator[metrics.length];
            this.factorizeAggs(metrics, aggs, rowContainer, row);
            this.doAggregate(aggs, rowContainer, row, reportParseExceptions);
            Integer rowIndex = this.indexIncrement.getAndIncrement();
            this.concurrentSet(rowIndex, aggs);
            if (numEntries.get() >= this.maxRowCount && !this.facts.containsKey(key)) {
                throw new IndexSizeExceededException("Maximum number of rows [%d] reached", this.maxRowCount);
            }
            Integer prev = this.facts.putIfAbsent(key, rowIndex);
            if (null == prev) {
                numEntries.incrementAndGet();
            } else {
                aggs = this.concurrentGet(prev);
                this.doAggregate(aggs, rowContainer, row, reportParseExceptions);
                this.concurrentRemove(rowIndex);
            }
        }
        return numEntries.get();
    }

    private void factorizeAggs(AggregatorFactory[] metrics, Aggregator[] aggs, ThreadLocal<InputRow> rowContainer, InputRow row) {
        rowContainer.set(row);
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            aggs[i] = agg.factorize(this.selectors.get(agg.getName()));
        }
        rowContainer.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAggregate(Aggregator[] aggs, ThreadLocal<InputRow> rowContainer, InputRow row, boolean reportParseExceptions) {
        rowContainer.set(row);
        Aggregator[] aggregatorArray = aggs;
        int n = aggregatorArray.length;
        for (int i = 0; i < n; ++i) {
            Aggregator agg;
            Aggregator aggregator = agg = aggregatorArray[i];
            synchronized (aggregator) {
                try {
                    agg.aggregate();
                }
                catch (ParseException e) {
                    if (reportParseExceptions) {
                        throw new ParseException((Throwable)e, "Encountered parse error for aggregator[%s]", new Object[]{agg.getName()});
                    }
                    log.debug((Throwable)e, "Encountered parse error, skipping aggregator[%s].", new Object[]{agg.getName()});
                }
                continue;
            }
        }
        rowContainer.set(null);
    }

    protected Aggregator[] concurrentGet(int offset) {
        return this.aggregators.get(offset);
    }

    protected void concurrentSet(int offset, Aggregator[] value) {
        this.aggregators.put(offset, value);
    }

    protected void concurrentRemove(int offset) {
        this.aggregators.remove(offset);
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean bl = canAdd = this.size() < this.maxRowCount;
        if (!canAdd) {
            this.outOfRowsReason = String.format("Maximum number of rows [%d] reached", this.maxRowCount);
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected Aggregator[] getAggsForRow(int rowOffset) {
        return this.concurrentGet(rowOffset);
    }

    @Override
    protected Object getAggVal(Aggregator agg, int rowOffset, int aggPosition) {
        return agg.get();
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getFloat();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getLong();
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].get();
    }

    @Override
    public void close() {
        super.close();
        this.aggregators.clear();
        this.facts.clear();
        if (this.selectors != null) {
            this.selectors.clear();
        }
    }

    static class ObjectCachingColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final ConcurrentMap<String, LongColumnSelector> longColumnSelectorMap = Maps.newConcurrentMap();
        private final ConcurrentMap<String, FloatColumnSelector> floatColumnSelectorMap = Maps.newConcurrentMap();
        private final ConcurrentMap<String, ObjectColumnSelector> objectColumnSelectorMap = Maps.newConcurrentMap();
        private final ColumnSelectorFactory delegate;

        public ObjectCachingColumnSelectorFactory(ColumnSelectorFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.delegate.makeDimensionSelector(dimensionSpec);
        }

        @Override
        public FloatColumnSelector makeFloatColumnSelector(String columnName) {
            FloatColumnSelector existing = (FloatColumnSelector)this.floatColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            FloatColumnSelector newSelector = this.delegate.makeFloatColumnSelector(columnName);
            FloatColumnSelector prev = this.floatColumnSelectorMap.putIfAbsent(columnName, newSelector);
            return prev != null ? prev : newSelector;
        }

        @Override
        public LongColumnSelector makeLongColumnSelector(String columnName) {
            LongColumnSelector existing = (LongColumnSelector)this.longColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            LongColumnSelector newSelector = this.delegate.makeLongColumnSelector(columnName);
            LongColumnSelector prev = this.longColumnSelectorMap.putIfAbsent(columnName, newSelector);
            return prev != null ? prev : newSelector;
        }

        @Override
        public ObjectColumnSelector makeObjectColumnSelector(String columnName) {
            ObjectColumnSelector existing = (ObjectColumnSelector)this.objectColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            ObjectColumnSelector newSelector = this.delegate.makeObjectColumnSelector(columnName);
            ObjectColumnSelector prev = this.objectColumnSelectorMap.putIfAbsent(columnName, newSelector);
            return prev != null ? prev : newSelector;
        }
    }

    static class OnHeapDimLookup<T extends Comparable<? super T>>
    implements IncrementalIndex.SortedDimLookup<T> {
        private final List<T> sortedVals;
        private final int[] idToIndex;
        private final int[] indexToId;

        public OnHeapDimLookup(List<T> idToValue, int length) {
            TreeMap sortedMap = Maps.newTreeMap();
            for (int id = 0; id < length; ++id) {
                sortedMap.put(idToValue.get(id), id);
            }
            this.sortedVals = Lists.newArrayList(sortedMap.keySet());
            this.idToIndex = new int[length];
            this.indexToId = new int[length];
            int index = 0;
            for (Integer id : sortedMap.values()) {
                this.idToIndex[id.intValue()] = index;
                this.indexToId[index] = id;
                ++index;
            }
        }

        @Override
        public int size() {
            return this.sortedVals.size();
        }

        @Override
        public int getUnsortedIdFromSortedId(int index) {
            return this.indexToId[index];
        }

        @Override
        public T getValueFromSortedId(int index) {
            return (T)((Comparable)this.sortedVals.get(index));
        }

        @Override
        public int getSortedIdFromUnsortedId(int id) {
            return this.idToIndex[id];
        }
    }

    static class OnHeapDimDim<T extends Comparable<? super T>>
    implements IncrementalIndex.DimDim<T> {
        private final Map<T, Integer> valueToId = Maps.newHashMap();
        private T minValue = null;
        private T maxValue = null;
        private final List<T> idToValue = Lists.newArrayList();
        private final Object lock;

        public OnHeapDimDim(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getId(T value) {
            Object object = this.lock;
            synchronized (object) {
                Integer id = this.valueToId.get(value);
                return id == null ? -1 : id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getValue(int id) {
            Object object = this.lock;
            synchronized (object) {
                return (T)((Comparable)this.idToValue.get(id));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(T value) {
            Object object = this.lock;
            synchronized (object) {
                return this.valueToId.containsKey(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.valueToId.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int add(T value) {
            Object object = this.lock;
            synchronized (object) {
                Integer prev = this.valueToId.get(value);
                if (prev != null) {
                    return prev;
                }
                int index = this.size();
                this.valueToId.put(value, index);
                this.idToValue.add(value);
                this.minValue = this.minValue == null || this.minValue.compareTo(value) > 0 ? value : this.minValue;
                this.maxValue = this.maxValue == null || this.maxValue.compareTo(value) < 0 ? value : this.maxValue;
                return index;
            }
        }

        @Override
        public T getMinValue() {
            return this.minValue;
        }

        @Override
        public T getMaxValue() {
            return this.maxValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OnHeapDimLookup sort() {
            Object object = this.lock;
            synchronized (object) {
                return new OnHeapDimLookup<T>(this.idToValue, this.size());
            }
        }
    }
}

