/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.column;

import io.druid.segment.column.AbstractColumn;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ComplexColumn;
import io.druid.segment.column.IndexedComplexColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.Indexed;

public class ComplexColumnImpl
extends AbstractColumn {
    private static final ColumnCapabilitiesImpl CAPABILITIES = new ColumnCapabilitiesImpl().setType(ValueType.COMPLEX);
    private final Indexed column;
    private final String typeName;

    public ComplexColumnImpl(String typeName, Indexed column) {
        this.column = column;
        this.typeName = typeName;
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public int getLength() {
        return this.column.size();
    }

    @Override
    public ComplexColumn getComplexColumn() {
        return new IndexedComplexColumn(this.typeName, this.column);
    }
}

