/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import io.druid.query.QueryRunnerHelper;
import io.druid.query.Result;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingOffset;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectResultValue;
import io.druid.query.select.SelectResultValueBuilder;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import io.druid.timeline.DataSegmentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class SelectQueryEngine {
    public Sequence<Result<SelectResultValue>> process(final SelectQuery query, Segment segment) {
        StorageAdapter adapter = segment.asStorageAdapter();
        if (adapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        String dataSource = (String)Iterables.getOnlyElement(query.getDataSource().getNames());
        final List<DimensionSpec> dims = query.getDimensions() == null || query.getDimensions().isEmpty() ? DefaultDimensionSpec.toSpec(adapter.getAvailableDimensions()) : query.getDimensions();
        final Iterable<String> metrics = query.getMetrics() == null || query.getMetrics().isEmpty() ? adapter.getAvailableMetrics() : query.getMetrics();
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument((intervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{intervals});
        final String segmentId = DataSegmentUtils.withInterval((String)dataSource, (String)segment.getIdentifier(), (Interval)intervals.get(0));
        return QueryRunnerHelper.makeCursorBasedQuery(adapter, query.getQuerySegmentSpec().getIntervals(), Filters.toFilter(query.getDimensionsFilter()), query.isDescending(), query.getGranularity(), new Function<Cursor, Result<SelectResultValue>>(){

            public Result<SelectResultValue> apply(Cursor cursor) {
                SelectResultValueBuilder builder = new SelectResultValueBuilder(cursor.getTime(), query.getPagingSpec(), query.isDescending());
                LongColumnSelector timestampColumnSelector = cursor.makeLongColumnSelector("__time");
                HashMap dimSelectors = Maps.newHashMap();
                for (Object dim : dims) {
                    DimensionSelector dimSelector = cursor.makeDimensionSelector((DimensionSpec)dim);
                    dimSelectors.put(dim.getOutputName(), dimSelector);
                }
                HashMap metSelectors = Maps.newHashMap();
                for (String metric : metrics) {
                    ObjectColumnSelector metricSelector = cursor.makeObjectColumnSelector(metric);
                    metSelectors.put(metric, metricSelector);
                }
                PagingOffset offset = query.getPagingOffset(segmentId);
                cursor.advanceTo(offset.startDelta());
                int lastOffset = offset.startOffset();
                while (!cursor.isDone() && offset.hasNext()) {
                    Object selector;
                    LinkedHashMap theEvent = Maps.newLinkedHashMap();
                    theEvent.put("timestamp", new DateTime(timestampColumnSelector.get()));
                    for (Map.Entry dimSelector : dimSelectors.entrySet()) {
                        String dim = (String)dimSelector.getKey();
                        selector = (DimensionSelector)dimSelector.getValue();
                        if (selector == null) {
                            theEvent.put(dim, null);
                            continue;
                        }
                        IndexedInts vals = selector.getRow();
                        if (vals.size() == 1) {
                            String dimVal = selector.lookupName(vals.get(0));
                            theEvent.put(dim, dimVal);
                            continue;
                        }
                        ArrayList dimVals = Lists.newArrayList();
                        for (int i = 0; i < vals.size(); ++i) {
                            dimVals.add(selector.lookupName(vals.get(i)));
                        }
                        theEvent.put(dim, dimVals);
                    }
                    for (Map.Entry metSelector : metSelectors.entrySet()) {
                        String metric = (String)metSelector.getKey();
                        selector = (ObjectColumnSelector)metSelector.getValue();
                        if (selector == null) {
                            theEvent.put(metric, null);
                            continue;
                        }
                        theEvent.put(metric, selector.get());
                    }
                    lastOffset = offset.current();
                    builder.addEntry(new EventHolder(segmentId, lastOffset, theEvent));
                    cursor.advance();
                    offset.next();
                }
                builder.finished(segmentId, lastOffset);
                return builder.build();
            }
        });
    }
}

