/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.orderby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.Row;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.groupby.orderby.TopNSorter;
import io.druid.query.ordering.StringComparators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultLimitSpec
implements LimitSpec {
    private static final byte CACHE_KEY = 1;
    private final List<OrderByColumnSpec> columns;
    private final int limit;

    @JsonCreator
    public DefaultLimitSpec(@JsonProperty(value="columns") List<OrderByColumnSpec> columns, @JsonProperty(value="limit") Integer limit) {
        this.columns = columns == null ? ImmutableList.of() : columns;
        this.limit = limit == null ? Integer.MAX_VALUE : limit;
        Preconditions.checkArgument((this.limit > 0 ? 1 : 0) != 0, (String)"limit[%s] must be >0", (Object[])new Object[]{limit});
    }

    @JsonProperty
    public List<OrderByColumnSpec> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    @Override
    public Function<Sequence<Row>, Sequence<Row>> build(List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs) {
        if (this.columns.isEmpty()) {
            return new LimitingFn(this.limit);
        }
        Ordering<Row> ordering = this.makeComparator(dimensions, aggs, postAggs);
        if (this.limit == Integer.MAX_VALUE) {
            return new SortingFn(ordering);
        }
        return new TopNFunction(ordering, this.limit);
    }

    @Override
    public LimitSpec merge(LimitSpec other) {
        return this;
    }

    private Ordering<Row> makeComparator(List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs) {
        Ordering<Row> ordering = new Ordering<Row>(){

            public int compare(Row left, Row right) {
                return Longs.compare((long)left.getTimestampFromEpoch(), (long)right.getTimestampFromEpoch());
            }
        };
        HashMap dimensionsMap = Maps.newHashMap();
        for (DimensionSpec dimensionSpec : dimensions) {
            dimensionsMap.put(dimensionSpec.getOutputName(), dimensionSpec);
        }
        HashMap aggregatorsMap = Maps.newHashMap();
        for (AggregatorFactory agg : aggs) {
            aggregatorsMap.put(agg.getName(), agg);
        }
        HashMap hashMap = Maps.newHashMap();
        for (PostAggregator postAgg : postAggs) {
            hashMap.put(postAgg.getName(), postAgg);
        }
        for (OrderByColumnSpec columnSpec : this.columns) {
            String columnName = columnSpec.getDimension();
            Ordering nextOrdering = null;
            if (hashMap.containsKey(columnName)) {
                nextOrdering = this.metricOrdering(columnName, ((PostAggregator)hashMap.get(columnName)).getComparator());
            } else if (aggregatorsMap.containsKey(columnName)) {
                nextOrdering = this.metricOrdering(columnName, ((AggregatorFactory)aggregatorsMap.get(columnName)).getComparator());
            } else if (dimensionsMap.containsKey(columnName)) {
                nextOrdering = this.dimensionOrdering(columnName, columnSpec.getDimensionComparator());
            }
            if (nextOrdering == null) {
                throw new ISE("Unknown column in order clause[%s]", new Object[]{columnSpec});
            }
            switch (columnSpec.getDirection()) {
                case DESCENDING: {
                    nextOrdering = nextOrdering.reverse();
                }
            }
            ordering = ordering.compound((Comparator)nextOrdering);
        }
        return ordering;
    }

    private Ordering<Row> metricOrdering(final String column, final Comparator comparator) {
        return new Ordering<Row>(){

            public int compare(Row left, Row right) {
                return comparator.compare(left.getRaw(column), right.getRaw(column));
            }
        };
    }

    private Ordering<Row> dimensionOrdering(final String dimension, StringComparators.StringComparator comparator) {
        return Ordering.from((Comparator)comparator).nullsFirst().onResultOf((Function)new Function<Row, String>(){

            public String apply(Row input) {
                List dimList = input.getDimension(dimension);
                return dimList.isEmpty() ? null : (String)dimList.get(0);
            }
        });
    }

    public String toString() {
        return "DefaultLimitSpec{columns='" + this.columns + '\'' + ", limit=" + this.limit + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLimitSpec that = (DefaultLimitSpec)o;
        if (this.limit != that.limit) {
            return false;
        }
        return !(this.columns != null ? !this.columns.equals(that.columns) : that.columns != null);
    }

    public int hashCode() {
        int result = this.columns != null ? this.columns.hashCode() : 0;
        result = 31 * result + this.limit;
        return result;
    }

    @Override
    public byte[] getCacheKey() {
        byte[][] columnBytes = new byte[this.columns.size()][];
        int columnsBytesSize = 0;
        int index = 0;
        for (OrderByColumnSpec column : this.columns) {
            columnBytes[index] = column.getCacheKey();
            columnsBytesSize += columnBytes[index].length;
            ++index;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + columnsBytesSize + 4).put((byte)1);
        for (byte[] columnByte : columnBytes) {
            buffer.put(columnByte);
        }
        buffer.put(Ints.toByteArray((int)this.limit));
        return buffer.array();
    }

    private static class TopNFunction
    implements Function<Sequence<Row>, Sequence<Row>> {
        private final TopNSorter<Row> sorter;
        private final int limit;

        public TopNFunction(Ordering<Row> ordering, int limit) {
            this.limit = limit;
            this.sorter = new TopNSorter<Row>(ordering);
        }

        public Sequence<Row> apply(Sequence<Row> input) {
            ArrayList materializedList = (ArrayList)Sequences.toList(input, (List)Lists.newArrayList());
            return Sequences.simple(this.sorter.toTopN(materializedList, this.limit));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopNFunction that = (TopNFunction)o;
            if (this.limit != that.limit) {
                return false;
            }
            return !(this.sorter != null ? !this.sorter.equals(that.sorter) : that.sorter != null);
        }

        public int hashCode() {
            int result = this.sorter != null ? this.sorter.hashCode() : 0;
            result = 31 * result + this.limit;
            return result;
        }
    }

    private static class SortingFn
    implements Function<Sequence<Row>, Sequence<Row>> {
        private final Ordering<Row> ordering;

        public SortingFn(Ordering<Row> ordering) {
            this.ordering = ordering;
        }

        public Sequence<Row> apply(@Nullable Sequence<Row> input) {
            return Sequences.sort(input, this.ordering);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortingFn sortingFn = (SortingFn)o;
            return !(this.ordering != null ? !this.ordering.equals(sortingFn.ordering) : sortingFn.ordering != null);
        }

        public int hashCode() {
            return this.ordering != null ? this.ordering.hashCode() : 0;
        }
    }

    private static class LimitingFn
    implements Function<Sequence<Row>, Sequence<Row>> {
        private int limit;

        public LimitingFn(int limit) {
            this.limit = limit;
        }

        public Sequence<Row> apply(Sequence<Row> input) {
            return Sequences.limit(input, (int)this.limit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LimitingFn that = (LimitingFn)o;
            return this.limit == that.limit;
        }

        public int hashCode() {
            return this.limit;
        }
    }
}

