/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.logger.Logger;
import io.druid.collections.StupidPool;
import io.druid.data.input.Row;
import io.druid.guice.annotations.Global;
import io.druid.query.GroupByMergedQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class GroupByQueryRunnerFactory
implements QueryRunnerFactory<Row, GroupByQuery> {
    private static final Logger log = new Logger(GroupByQueryRunnerFactory.class);
    private final GroupByQueryEngine engine;
    private final QueryWatcher queryWatcher;
    private final Supplier<GroupByQueryConfig> config;
    private final GroupByQueryQueryToolChest toolChest;
    private final StupidPool<ByteBuffer> computationBufferPool;

    @Inject
    public GroupByQueryRunnerFactory(GroupByQueryEngine engine, QueryWatcher queryWatcher, Supplier<GroupByQueryConfig> config, GroupByQueryQueryToolChest toolChest, @Global StupidPool<ByteBuffer> computationBufferPool) {
        this.engine = engine;
        this.queryWatcher = queryWatcher;
        this.config = config;
        this.toolChest = toolChest;
        this.computationBufferPool = computationBufferPool;
    }

    @Override
    public QueryRunner<Row> createRunner(Segment segment) {
        return new GroupByQueryRunner(segment, this.engine);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator((ExecutorService)exec);
        return new GroupByMergedQueryRunner<Row>((ExecutorService)queryExecutor, this.config, this.queryWatcher, this.computationBufferPool, queryRunners);
    }

    @Override
    public QueryToolChest<Row, GroupByQuery> getToolchest() {
        return this.toolChest;
    }

    private static class GroupByQueryRunner
    implements QueryRunner<Row> {
        private final StorageAdapter adapter;
        private final GroupByQueryEngine engine;

        public GroupByQueryRunner(Segment segment, GroupByQueryEngine engine) {
            this.adapter = segment.asStorageAdapter();
            this.engine = engine;
        }

        @Override
        public Sequence<Row> run(Query<Row> input, Map<String, Object> responseContext) {
            if (!(input instanceof GroupByQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), GroupByQuery.class});
            }
            return this.engine.process((GroupByQuery)input, this.adapter);
        }
    }
}

