/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.druid.query.Druids;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DimFilterCacheHelper;
import io.druid.query.filter.DimFilters;
import io.druid.query.filter.Filter;
import io.druid.segment.filter.Filters;
import io.druid.segment.filter.OrFilter;
import java.util.List;

public class OrDimFilter
implements DimFilter {
    private static final Joiner OR_JOINER = Joiner.on((String)" || ");
    private final List<DimFilter> fields;

    @JsonCreator
    public OrDimFilter(@JsonProperty(value="fields") List<DimFilter> fields) {
        fields = DimFilters.filterNulls(fields);
        Preconditions.checkArgument((fields.size() > 0 ? 1 : 0) != 0, (Object)"OR operator requires at least one field");
        this.fields = fields;
    }

    @JsonProperty
    public List<DimFilter> getFields() {
        return this.fields;
    }

    @Override
    public byte[] getCacheKey() {
        return DimFilterCacheHelper.computeCacheKey((byte)2, this.fields);
    }

    @Override
    public DimFilter optimize() {
        List<DimFilter> elements = DimFilters.optimize(this.fields);
        return elements.size() == 1 ? elements.get(0) : Druids.newOrDimFilterBuilder().fields(elements).build();
    }

    @Override
    public Filter toFilter() {
        return new OrFilter(Filters.toFilters(this.fields));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrDimFilter that = (OrDimFilter)o;
        return !(this.fields != null ? !this.fields.equals(that.fields) : that.fields != null);
    }

    public int hashCode() {
        return this.fields != null ? this.fields.hashCode() : 0;
    }

    public String toString() {
        return String.format("(%s)", OR_JOINER.join(this.fields));
    }
}

