/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.Filter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.lookup.LookupExtractionFn;
import io.druid.query.lookup.LookupExtractor;
import io.druid.segment.filter.InFilter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class InDimFilter
implements DimFilter {
    private final ImmutableSortedSet<String> values;
    private final String dimension;
    private final ExtractionFn extractionFn;

    @JsonCreator
    public InDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="values") List<String> values, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension can not be null");
        Preconditions.checkArgument((values != null && !values.isEmpty() ? 1 : 0) != 0, (Object)"values can not be null or empty");
        this.values = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(values, (Function)new Function<String, String>(){

            public String apply(String input) {
                return Strings.nullToEmpty((String)input);
            }
        }));
        this.dimension = dimension;
        this.extractionFn = extractionFn;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[][] valuesBytes = new byte[this.values.size()][];
        int valuesBytesSize = 0;
        int index = 0;
        for (String value : this.values) {
            valuesBytes[index] = StringUtils.toUtf8((String)Strings.nullToEmpty((String)value));
            valuesBytesSize += valuesBytes[index].length + 1;
            ++index;
        }
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        ByteBuffer filterCacheKey = ByteBuffer.allocate(3 + dimensionBytes.length + valuesBytesSize + extractionFnBytes.length).put((byte)9).put(dimensionBytes).put((byte)-1).put(extractionFnBytes).put((byte)-1);
        for (byte[] bytes : valuesBytes) {
            filterCacheKey.put(bytes).put((byte)-1);
        }
        return filterCacheKey.array();
    }

    @Override
    public DimFilter optimize() {
        InDimFilter inFilter = this.optimizeLookup();
        if (inFilter.values.size() == 1) {
            return new SelectorDimFilter(inFilter.dimension, (String)inFilter.values.first(), inFilter.getExtractionFn());
        }
        return inFilter;
    }

    private InDimFilter optimizeLookup() {
        if (this.extractionFn instanceof LookupExtractionFn && ((LookupExtractionFn)this.extractionFn).isOptimize()) {
            LookupExtractionFn exFn = (LookupExtractionFn)this.extractionFn;
            LookupExtractor lookup = exFn.getLookup();
            ArrayList<String> keys = new ArrayList<String>();
            for (String value : this.values) {
                String convertedValue = Strings.emptyToNull((String)value);
                if (!exFn.isRetainMissingValue() && Objects.equals(convertedValue, exFn.getReplaceMissingValueWith())) {
                    return this;
                }
                keys.addAll(lookup.unapply(convertedValue));
                if (!exFn.isRetainMissingValue() || lookup.apply(convertedValue) != null) continue;
                keys.add(convertedValue);
            }
            if (keys.isEmpty()) {
                return this;
            }
            return new InDimFilter(this.dimension, keys, null);
        }
        return this;
    }

    @Override
    public Filter toFilter() {
        return new InFilter(this.dimension, (Set<String>)this.values, this.extractionFn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDimFilter that = (InDimFilter)o;
        if (this.values != null ? !this.values.equals(that.values) : that.values != null) {
            return false;
        }
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.values != null ? this.values.hashCode() : 0;
        result = 31 * result + this.dimension.hashCode();
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }
}

