/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeFormatExtractionFn
implements ExtractionFn {
    private final DateTimeZone tz;
    private final String pattern;
    private final Locale locale;
    private final DateTimeFormatter formatter;

    public TimeFormatExtractionFn(@JsonProperty(value="format") String pattern, @JsonProperty(value="timeZone") DateTimeZone tz, @JsonProperty(value="locale") String localeString) {
        Preconditions.checkArgument((pattern != null ? 1 : 0) != 0, (Object)"format cannot be null");
        this.pattern = pattern;
        this.tz = tz;
        this.locale = localeString == null ? null : Locale.forLanguageTag(localeString);
        this.formatter = DateTimeFormat.forPattern((String)pattern).withZone(tz == null ? DateTimeZone.UTC : tz).withLocale(this.locale);
    }

    @JsonProperty
    public DateTimeZone getTimeZone() {
        return this.tz;
    }

    @JsonProperty
    public String getFormat() {
        return this.pattern;
    }

    @JsonProperty
    public String getLocale() {
        if (this.locale != null) {
            return this.locale.toLanguageTag();
        }
        return null;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] exprBytes = StringUtils.toUtf8((String)(this.pattern + "\u0001" + this.tz.getID() + "\u0001" + this.locale.toLanguageTag()));
        return ByteBuffer.allocate(1 + exprBytes.length).put((byte)5).put(exprBytes).array();
    }

    @Override
    public String apply(long value) {
        return this.formatter.print(value);
    }

    @Override
    public String apply(Object value) {
        return this.formatter.print((ReadableInstant)new DateTime(value));
    }

    @Override
    public String apply(String value) {
        return this.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeFormatExtractionFn that = (TimeFormatExtractionFn)o;
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (!this.pattern.equals(that.pattern)) {
            return false;
        }
        return !(this.tz != null ? !this.tz.equals((Object)that.tz) : that.tz != null);
    }

    public int hashCode() {
        int result = this.tz != null ? this.tz.hashCode() : 0;
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        return result;
    }
}

