/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.metamx.common.ISE;
import com.metamx.common.StringUtils;
import io.druid.js.JavaScriptConfig;
import io.druid.query.extraction.ExtractionFn;
import java.nio.ByteBuffer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptExtractionFn
implements ExtractionFn {
    private final String function;
    private final Function<Object, String> fn;
    private final boolean injective;

    private static Function<Object, String> compile(String function) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fn = context.compileFunction((Scriptable)scope, function, "fn", 1, null);
        Context.exit();
        return new Function<Object, String>(){

            public String apply(Object input) {
                Object res;
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                }
                return (res = fn.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{input})) != null ? Context.toString((Object)res) : null;
            }
        };
    }

    @JsonCreator
    public JavaScriptExtractionFn(@JsonProperty(value="function") String function, @JsonProperty(value="injective") boolean injective, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull((Object)function, (Object)"function must not be null");
        this.function = function;
        this.injective = injective;
        this.fn = config.isDisabled() ? null : JavaScriptExtractionFn.compile(function);
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @JsonProperty
    public boolean isInjective() {
        return this.injective;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] bytes = StringUtils.toUtf8((String)this.function);
        return ByteBuffer.allocate(1 + bytes.length).put((byte)4).put(bytes).array();
    }

    @Override
    public String apply(Object value) {
        if (this.fn == null) {
            throw new ISE("JavaScript is disabled", new Object[0]);
        }
        return Strings.emptyToNull((String)((String)this.fn.apply(value)));
    }

    @Override
    public String apply(String value) {
        return this.apply((Object)Strings.emptyToNull((String)value));
    }

    @Override
    public String apply(long value) {
        return this.apply((Object)value);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return this.injective ? ExtractionFn.ExtractionType.ONE_TO_ONE : ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public String toString() {
        return "JavascriptDimExtractionFn{function='" + this.function + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptExtractionFn that = (JavaScriptExtractionFn)o;
        return this.function.equals(that.function);
    }

    public int hashCode() {
        return this.function.hashCode();
    }
}

