/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.httpclient5;

import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.httpclient5.HttpClientMetricNameStrategies;
import io.dropwizard.metrics5.httpclient5.HttpClientMetricNameStrategy;
import io.dropwizard.metrics5.httpclient5.InstrumentedHttpClientConnectionManager;
import io.dropwizard.metrics5.httpclient5.InstrumentedHttpRequestExecutor;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;

public class InstrumentedHttpClients {
    private InstrumentedHttpClients() {
    }

    public static CloseableHttpClient createDefault(MetricRegistry metricRegistry) {
        return InstrumentedHttpClients.createDefault(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static CloseableHttpClient createDefault(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return InstrumentedHttpClients.custom(metricRegistry, metricNameStrategy).build();
    }

    public static HttpClientBuilder custom(MetricRegistry metricRegistry) {
        return InstrumentedHttpClients.custom(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static HttpClientBuilder custom(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return HttpClientBuilder.create().setRequestExecutor((HttpRequestExecutor)new InstrumentedHttpRequestExecutor(metricRegistry, metricNameStrategy)).setConnectionManager((HttpClientConnectionManager)InstrumentedHttpClientConnectionManager.builder(metricRegistry).build());
    }
}

