/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.httpclient;

import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import io.dropwizard.metrics5.httpclient.HttpClientMetricNameStrategy;
import java.io.IOException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class InstrumentedHttpRequestExecutor
extends HttpRequestExecutor {
    private final MetricRegistry registry;
    private final HttpClientMetricNameStrategy metricNameStrategy;
    private final String name;

    public InstrumentedHttpRequestExecutor(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy) {
        this(registry, metricNameStrategy, null);
    }

    public InstrumentedHttpRequestExecutor(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy, String name) {
        this(registry, metricNameStrategy, name, 3000);
    }

    public InstrumentedHttpRequestExecutor(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy, String name, int waitForContinue) {
        super(waitForContinue);
        this.registry = registry;
        this.name = name;
        this.metricNameStrategy = metricNameStrategy;
    }

    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        Timer.Context timerContext = this.timer(request).time();
        try {
            HttpResponse httpResponse = super.execute(request, conn, context);
            return httpResponse;
        }
        catch (IOException | HttpException e) {
            this.meter((Exception)e).mark();
            throw e;
        }
        finally {
            timerContext.stop();
        }
    }

    private Timer timer(HttpRequest request) {
        return this.registry.timer(this.metricNameStrategy.getNameFor(this.name, request));
    }

    private Meter meter(Exception e) {
        return this.registry.meter(this.metricNameStrategy.getNameFor(this.name, e));
    }
}

