/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.httpclient;

import io.dropwizard.metrics5.MetricRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;

public class InstrumentedHttpClientConnectionManager
extends PoolingHttpClientConnectionManager {
    private final MetricRegistry metricsRegistry;
    private final String name;

    protected static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
    }

    @Deprecated
    public InstrumentedHttpClientConnectionManager(MetricRegistry metricRegistry) {
        this(metricRegistry, InstrumentedHttpClientConnectionManager.getDefaultRegistry());
    }

    @Deprecated
    public InstrumentedHttpClientConnectionManager(MetricRegistry metricsRegistry, Registry<ConnectionSocketFactory> socketFactoryRegistry) {
        this(metricsRegistry, socketFactoryRegistry, -1L, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public InstrumentedHttpClientConnectionManager(MetricRegistry metricsRegistry, Registry<ConnectionSocketFactory> socketFactoryRegistry, long connTTL, TimeUnit connTTLTimeUnit) {
        this(metricsRegistry, socketFactoryRegistry, null, null, (DnsResolver)SystemDefaultDnsResolver.INSTANCE, connTTL, connTTLTimeUnit, null);
    }

    @Deprecated
    public InstrumentedHttpClientConnectionManager(MetricRegistry metricsRegistry, Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long connTTL, TimeUnit connTTLTimeUnit, String name) {
        this(metricsRegistry, (HttpClientConnectionOperator)new DefaultHttpClientConnectionOperator(socketFactoryRegistry, schemePortResolver, dnsResolver), connFactory, connTTL, connTTLTimeUnit, name);
    }

    @Deprecated
    public InstrumentedHttpClientConnectionManager(MetricRegistry metricsRegistry, HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, long connTTL, TimeUnit connTTLTimeUnit, String name) {
        super(httpClientConnectionOperator, connFactory, connTTL, connTTLTimeUnit);
        this.metricsRegistry = metricsRegistry;
        this.name = name;
        metricsRegistry.registerGauge(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{name, "available-connections"}), () -> this.getTotalStats().getAvailable());
        metricsRegistry.registerGauge(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{name, "leased-connections"}), () -> this.getTotalStats().getLeased());
        metricsRegistry.registerGauge(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{name, "max-connections"}), () -> this.getTotalStats().getMax());
        metricsRegistry.registerGauge(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{name, "pending-connections"}), () -> this.getTotalStats().getPending());
    }

    public void shutdown() {
        super.shutdown();
        this.metricsRegistry.remove(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{this.name, "available-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{this.name, "leased-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{this.name, "max-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name(HttpClientConnectionManager.class, (String[])new String[]{this.name, "pending-connections"}));
    }

    public static Builder builder(MetricRegistry metricsRegistry) {
        return new Builder().metricsRegistry(metricsRegistry);
    }

    public static class Builder {
        private MetricRegistry metricsRegistry;
        private HttpClientConnectionOperator httpClientConnectionOperator;
        private Registry<ConnectionSocketFactory> socketFactoryRegistry = InstrumentedHttpClientConnectionManager.getDefaultRegistry();
        private HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
        private SchemePortResolver schemePortResolver;
        private DnsResolver dnsResolver = SystemDefaultDnsResolver.INSTANCE;
        private long connTTL = -1L;
        private TimeUnit connTTLTimeUnit = TimeUnit.MILLISECONDS;
        private String name;

        Builder() {
        }

        public Builder metricsRegistry(MetricRegistry metricsRegistry) {
            this.metricsRegistry = metricsRegistry;
            return this;
        }

        public Builder socketFactoryRegistry(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
            this.socketFactoryRegistry = socketFactoryRegistry;
            return this;
        }

        public Builder connFactory(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory) {
            this.connFactory = connFactory;
            return this;
        }

        public Builder schemePortResolver(SchemePortResolver schemePortResolver) {
            this.schemePortResolver = schemePortResolver;
            return this;
        }

        public Builder dnsResolver(DnsResolver dnsResolver) {
            this.dnsResolver = dnsResolver;
            return this;
        }

        public Builder connTTL(long connTTL) {
            this.connTTL = connTTL;
            return this;
        }

        public Builder connTTLTimeUnit(TimeUnit connTTLTimeUnit) {
            this.connTTLTimeUnit = connTTLTimeUnit;
            return this;
        }

        public Builder httpClientConnectionOperator(HttpClientConnectionOperator httpClientConnectionOperator) {
            this.httpClientConnectionOperator = httpClientConnectionOperator;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public InstrumentedHttpClientConnectionManager build() {
            if (this.httpClientConnectionOperator == null) {
                this.httpClientConnectionOperator = new DefaultHttpClientConnectionOperator(this.socketFactoryRegistry, this.schemePortResolver, this.dnsResolver);
            }
            return new InstrumentedHttpClientConnectionManager(this.metricsRegistry, this.httpClientConnectionOperator, this.connFactory, this.connTTL, this.connTTLTimeUnit, this.name);
        }
    }
}

