/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.ehcache;

import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;

public class InstrumentedEhcache
extends EhcacheDecoratorAdapter {
    private final Timer getTimer;
    private final Timer putTimer;

    public static Ehcache instrument(MetricRegistry registry, Ehcache cache) {
        MetricName prefix = MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName()});
        registry.register(prefix.resolve("hits"), (Metric)((Gauge)() -> cache.getStatistics().cacheHitCount()));
        registry.register(prefix.resolve("in-memory-hits"), (Metric)((Gauge)() -> cache.getStatistics().localHeapHitCount()));
        registry.register(prefix.resolve("off-heap-hits"), (Metric)((Gauge)() -> cache.getStatistics().localOffHeapHitCount()));
        registry.register(prefix.resolve("on-disk-hits"), (Metric)((Gauge)() -> cache.getStatistics().localDiskHitCount()));
        registry.register(prefix.resolve("misses"), (Metric)((Gauge)() -> cache.getStatistics().cacheMissCount()));
        registry.register(prefix.resolve("in-memory-misses"), (Metric)((Gauge)() -> cache.getStatistics().localHeapMissCount()));
        registry.register(prefix.resolve("off-heap-misses"), (Metric)((Gauge)() -> cache.getStatistics().localOffHeapMissCount()));
        registry.register(prefix.resolve("on-disk-misses"), (Metric)((Gauge)() -> cache.getStatistics().localDiskMissCount()));
        registry.register(prefix.resolve("objects"), (Metric)((Gauge)() -> cache.getStatistics().getSize()));
        registry.register(prefix.resolve("in-memory-objects"), (Metric)((Gauge)() -> cache.getStatistics().getLocalHeapSize()));
        registry.register(prefix.resolve("off-heap-objects"), (Metric)((Gauge)() -> cache.getStatistics().getLocalOffHeapSize()));
        registry.register(prefix.resolve("on-disk-objects"), (Metric)((Gauge)() -> cache.getStatistics().getLocalDiskSize()));
        registry.register(prefix.resolve("mean-get-time"), (Metric)((Gauge)() -> (Double)cache.getStatistics().cacheGetOperation().latency().average().value()));
        registry.register(prefix.resolve("mean-search-time"), (Metric)((Gauge)() -> (Double)cache.getStatistics().cacheSearchOperation().latency().average().value()));
        registry.register(prefix.resolve("eviction-count"), (Metric)((Gauge)() -> (Long)cache.getStatistics().cacheEvictionOperation().count().value()));
        registry.register(prefix.resolve("searches-per-second"), (Metric)((Gauge)() -> (Double)cache.getStatistics().cacheSearchOperation().rate().value()));
        registry.register(prefix.resolve("writer-queue-size"), (Metric)((Gauge)() -> cache.getStatistics().getWriterQueueLength()));
        return new InstrumentedEhcache(registry, cache);
    }

    private InstrumentedEhcache(MetricRegistry registry, Ehcache cache) {
        super(cache);
        this.getTimer = registry.timer(MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName(), "gets"}));
        this.putTimer = registry.timer(MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName(), "puts"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) throws IllegalStateException, CacheException {
        Timer.Context ctx = this.getTimer.time();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Serializable key) throws IllegalStateException, CacheException {
        Timer.Context ctx = this.getTimer.time();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            ctx.stop();
        }
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        Timer.Context ctx = this.putTimer.time();
        try {
            this.underlyingCache.put(element);
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        Timer.Context ctx = this.putTimer.time();
        try {
            this.underlyingCache.put(element, doNotNotifyCacheReplicators);
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(Element element) throws NullPointerException {
        Timer.Context ctx = this.putTimer.time();
        try {
            Element element2 = this.underlyingCache.putIfAbsent(element);
            return element2;
        }
        finally {
            ctx.stop();
        }
    }
}

