/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.ehcache;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.EhcacheDecoratorAdapter;

public class InstrumentedEhcache
extends EhcacheDecoratorAdapter {
    private final Timer getTimer;
    private final Timer putTimer;

    public static Ehcache instrument(MetricRegistry registry, Ehcache cache) {
        String prefix = MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName()});
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"hits"}), (Metric)((Gauge)() -> cache.getStatistics().cacheHitCount()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"in-memory-hits"}), (Metric)((Gauge)() -> cache.getStatistics().localHeapHitCount()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"off-heap-hits"}), (Metric)((Gauge)() -> cache.getStatistics().localOffHeapHitCount()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"on-disk-hits"}), (Metric)((Gauge)() -> cache.getStatistics().localDiskHitCount()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"misses"}), (Metric)((Gauge)() -> cache.getStatistics().cacheMissCount()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"in-memory-misses"}), (Metric)((Gauge)() -> cache.getStatistics().localHeapMissCount()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"off-heap-misses"}), (Metric)((Gauge)() -> cache.getStatistics().localOffHeapMissCount()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"on-disk-misses"}), (Metric)((Gauge)() -> cache.getStatistics().localDiskMissCount()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"objects"}), (Metric)((Gauge)() -> cache.getStatistics().getSize()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"in-memory-objects"}), (Metric)((Gauge)() -> cache.getStatistics().getLocalHeapSize()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"off-heap-objects"}), (Metric)((Gauge)() -> cache.getStatistics().getLocalOffHeapSize()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"on-disk-objects"}), (Metric)((Gauge)() -> cache.getStatistics().getLocalDiskSize()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"mean-get-time"}), (Metric)((Gauge)() -> (Double)cache.getStatistics().cacheGetOperation().latency().average().value()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"mean-search-time"}), (Metric)((Gauge)() -> (Double)cache.getStatistics().cacheSearchOperation().latency().average().value()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"eviction-count"}), (Metric)((Gauge)() -> (Long)cache.getStatistics().cacheEvictionOperation().count().value()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"searches-per-second"}), (Metric)((Gauge)() -> (Double)cache.getStatistics().cacheSearchOperation().rate().value()));
        registry.register(MetricRegistry.name((String)prefix, (String[])new String[]{"writer-queue-size"}), (Metric)((Gauge)() -> cache.getStatistics().getWriterQueueLength()));
        return new InstrumentedEhcache(registry, cache);
    }

    private InstrumentedEhcache(MetricRegistry registry, Ehcache cache) {
        super(cache);
        this.getTimer = registry.timer(MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName(), "gets"}));
        this.putTimer = registry.timer(MetricRegistry.name(cache.getClass(), (String[])new String[]{cache.getName(), "puts"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) throws IllegalStateException, CacheException {
        Timer.Context ctx = this.getTimer.time();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Serializable key) throws IllegalStateException, CacheException {
        Timer.Context ctx = this.getTimer.time();
        try {
            Element element = this.underlyingCache.get(key);
            return element;
        }
        finally {
            ctx.stop();
        }
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        Timer.Context ctx = this.putTimer.time();
        try {
            this.underlyingCache.put(element);
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        Timer.Context ctx = this.putTimer.time();
        try {
            this.underlyingCache.put(element, doNotNotifyCacheReplicators);
        }
        finally {
            ctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(Element element) throws NullPointerException {
        Timer.Context ctx = this.putTimer.time();
        try {
            Element element2 = this.underlyingCache.putIfAbsent(element);
            return element2;
        }
        finally {
            ctx.stop();
        }
    }
}

