/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Context;
import io.dropwizard.logging.common.PrefixedExtendedThrowableProxyConverter;
import io.dropwizard.logging.common.PrefixedRootCauseFirstThrowableProxyConverter;
import io.dropwizard.logging.common.PrefixedThrowableProxyConverter;
import java.util.TimeZone;

public class DropwizardLayout
extends PatternLayout {
    public DropwizardLayout(LoggerContext context, TimeZone timeZone) {
        this.setOutputPatternAsHeader(false);
        this.getDefaultConverterSupplierMap().put("dwEx", PrefixedThrowableProxyConverter::new);
        this.getDefaultConverterSupplierMap().put("dwException", PrefixedThrowableProxyConverter::new);
        this.getDefaultConverterSupplierMap().put("dwThrowable", PrefixedThrowableProxyConverter::new);
        this.getDefaultConverterSupplierMap().put("dwREx", PrefixedRootCauseFirstThrowableProxyConverter::new);
        this.getDefaultConverterSupplierMap().put("dwRootException", PrefixedRootCauseFirstThrowableProxyConverter::new);
        this.getDefaultConverterSupplierMap().put("dwXEx", PrefixedExtendedThrowableProxyConverter::new);
        this.getDefaultConverterSupplierMap().put("dwXException", PrefixedExtendedThrowableProxyConverter::new);
        this.getDefaultConverterSupplierMap().put("dwXThrowable", PrefixedExtendedThrowableProxyConverter::new);
        this.setPattern("%-5p [%d{ISO8601," + timeZone.getID() + "}] %c: %m%n%dwREx");
        this.setContext((Context)context);
    }
}

