/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategies;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategy;
import com.codahale.metrics.httpclient5.InstrumentedHttpClientConnectionManager;
import com.codahale.metrics.httpclient5.InstrumentedHttpRequestExecutor;
import io.dropwizard.client.ConfiguredCloseableHttpClient;
import io.dropwizard.client.DropwizardSSLConnectionSocketFactory;
import io.dropwizard.client.HttpClientConfiguration;
import io.dropwizard.client.proxy.AuthConfiguration;
import io.dropwizard.client.proxy.NonProxyListProxyRoutePlanner;
import io.dropwizard.client.proxy.ProxyConfiguration;
import io.dropwizard.client.ssl.TlsConfiguration;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.util.Duration;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HttpClientBuilder {
    private static final HttpRequestRetryStrategy NO_RETRIES = new HttpRequestRetryStrategy(){

        public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
            return false;
        }

        public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
            return false;
        }

        public @Nullable TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
            return null;
        }
    };
    private final MetricRegistry metricRegistry;
    private @Nullable String environmentName;
    private @Nullable Environment environment;
    private HttpClientConfiguration configuration = new HttpClientConfiguration();
    private DnsResolver resolver = new SystemDefaultDnsResolver();
    private @Nullable HostnameVerifier verifier;
    private @Nullable HttpRequestRetryStrategy httpRequestRetryStrategy;
    private @Nullable Registry<ConnectionSocketFactory> registry;
    private @Nullable CredentialsStore credentialsStore;
    private HttpClientMetricNameStrategy metricNameStrategy = HttpClientMetricNameStrategies.METHOD_ONLY;
    private @Nullable HttpRoutePlanner routePlanner;
    private @Nullable RedirectStrategy redirectStrategy;
    private boolean disableContentCompression;
    private @Nullable List<? extends Header> defaultHeaders;
    private @Nullable HttpProcessor httpProcessor;

    public HttpClientBuilder(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public HttpClientBuilder(Environment environment) {
        this(environment.metrics());
        this.name(environment.getName());
        this.environment = environment;
    }

    public HttpClientBuilder name(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public HttpClientBuilder using(HttpClientConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HttpClientBuilder using(DnsResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public HttpClientBuilder using(HostnameVerifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public HttpClientBuilder using(HttpRequestRetryStrategy httpRequestRetryStrategy) {
        this.httpRequestRetryStrategy = httpRequestRetryStrategy;
        return this;
    }

    public HttpClientBuilder using(Registry<ConnectionSocketFactory> registry) {
        this.registry = registry;
        return this;
    }

    public HttpClientBuilder using(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
        return this;
    }

    public HttpClientBuilder using(CredentialsStore credentialsStore) {
        this.credentialsStore = credentialsStore;
        return this;
    }

    public HttpClientBuilder using(HttpClientMetricNameStrategy metricNameStrategy) {
        this.metricNameStrategy = metricNameStrategy;
        return this;
    }

    public HttpClientBuilder using(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
        return this;
    }

    public HttpClientBuilder using(List<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public HttpClientBuilder using(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public HttpClientBuilder disableContentCompression(boolean disableContentCompression) {
        this.disableContentCompression = disableContentCompression;
        return this;
    }

    public CloseableHttpClient build(String name) {
        final CloseableHttpClient client = this.buildWithDefaultRequestConfiguration(name).getClient();
        if (this.environment != null) {
            this.environment.lifecycle().manage(new Managed(){

                public void stop() throws Exception {
                    client.close();
                }
            });
        }
        return client;
    }

    ConfiguredCloseableHttpClient buildWithDefaultRequestConfiguration(String name) {
        return this.createClient(this.createBuilder(), this.createConnectionManager(this.createConfiguredRegistry(), name), name);
    }

    protected HttpRequestExecutor createRequestExecutor(String name) {
        return new InstrumentedHttpRequestExecutor(this.metricRegistry, this.metricNameStrategy, name);
    }

    protected org.apache.hc.client5.http.impl.classic.HttpClientBuilder createBuilder() {
        return org.apache.hc.client5.http.impl.classic.HttpClientBuilder.create();
    }

    protected org.apache.hc.client5.http.impl.classic.HttpClientBuilder customizeBuilder(org.apache.hc.client5.http.impl.classic.HttpClientBuilder builder) {
        return builder;
    }

    protected ConfiguredCloseableHttpClient createClient(org.apache.hc.client5.http.impl.classic.HttpClientBuilder builder, InstrumentedHttpClientConnectionManager manager, String name) {
        ProxyConfiguration proxy;
        ConnectionReuseStrategy reuseStrategy;
        String cookiePolicy = this.configuration.isCookiesEnabled() ? "relaxed" : "ignore";
        int timeout = (int)this.configuration.getTimeout().toMilliseconds();
        int connectionRequestTimeout = (int)this.configuration.getConnectionRequestTimeout().toMilliseconds();
        final long keepAlive = this.configuration.getKeepAlive().toMilliseconds();
        Object object = reuseStrategy = keepAlive == 0L ? (request, response, context) -> false : new DefaultConnectionReuseStrategy();
        HttpRequestRetryStrategy retryHandler = this.configuration.getRetries() == 0 ? NO_RETRIES : (this.httpRequestRetryStrategy == null ? new DefaultHttpRequestRetryStrategy(this.configuration.getRetries(), TimeValue.ofSeconds((long)1L)) : this.httpRequestRetryStrategy);
        boolean protocolUpgradeEnabled = this.configuration.isProtocolUpgradeEnabled();
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec(cookiePolicy).setResponseTimeout((long)timeout, TimeUnit.MILLISECONDS).setConnectionKeepAlive(TimeValue.of((long)-1L, (TimeUnit)TimeUnit.MILLISECONDS)).setConnectionRequestTimeout((long)connectionRequestTimeout, TimeUnit.MILLISECONDS).setProtocolUpgradeEnabled(protocolUpgradeEnabled).build();
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(timeout, TimeUnit.MILLISECONDS).build();
        manager.setDefaultSocketConfig(socketConfig);
        builder.setRequestExecutor(this.createRequestExecutor(name)).setConnectionManager((HttpClientConnectionManager)manager).setDefaultRequestConfig(requestConfig).setConnectionReuseStrategy(reuseStrategy).setRetryStrategy(retryHandler).setUserAgent(this.createUserAgent(name));
        if (keepAlive != 0L) {
            builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    TimeValue duration = super.getKeepAliveDuration(response, context);
                    return duration.getDuration() == -1L ? TimeValue.ofMilliseconds((long)keepAlive) : duration;
                }
            });
        }
        if ((proxy = this.configuration.getProxyConfiguration()) != null) {
            HttpHost httpHost = new HttpHost(proxy.getScheme(), proxy.getHost(), proxy.getPort().intValue());
            builder.setRoutePlanner((HttpRoutePlanner)new NonProxyListProxyRoutePlanner(httpHost, proxy.getNonProxyHosts()));
            AuthConfiguration auth = proxy.getAuth();
            if (auth != null) {
                if (this.credentialsStore == null) {
                    this.credentialsStore = new BasicCredentialsProvider();
                }
                AuthScope authScope = new AuthScope(httpHost, auth.getRealm(), auth.getAuthScheme());
                Credentials credentials = this.configureCredentials(auth);
                this.credentialsStore.setCredentials(authScope, credentials);
            }
        }
        if (this.credentialsStore != null) {
            builder.setDefaultCredentialsProvider((CredentialsProvider)this.credentialsStore);
        }
        if (this.routePlanner != null) {
            builder.setRoutePlanner(this.routePlanner);
        }
        if (this.disableContentCompression) {
            builder.disableContentCompression();
        }
        if (this.redirectStrategy != null) {
            builder.setRedirectStrategy(this.redirectStrategy);
        }
        if (this.defaultHeaders != null) {
            builder.setDefaultHeaders(this.defaultHeaders);
        }
        if (this.httpProcessor != null) {
            builder.addRequestInterceptorFirst((HttpRequestInterceptor)this.httpProcessor);
            builder.addResponseInterceptorLast((HttpResponseInterceptor)this.httpProcessor);
        }
        this.customizeBuilder(builder);
        return new ConfiguredCloseableHttpClient(builder.build(), requestConfig);
    }

    protected String createUserAgent(String name) {
        String defaultUserAgent = this.environmentName == null ? name : String.format("%s (%s)", this.environmentName, name);
        return this.configuration.getUserAgent().orElse(defaultUserAgent);
    }

    protected InstrumentedHttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry, String name) {
        Duration ttl = this.configuration.getTimeToLive();
        InstrumentedHttpClientConnectionManager manager = InstrumentedHttpClientConnectionManager.builder((MetricRegistry)this.metricRegistry).socketFactoryRegistry(registry).dnsResolver(this.resolver).timeToLive(TimeValue.of((long)ttl.getQuantity(), (TimeUnit)ttl.getUnit())).name(name).build();
        return this.configureConnectionManager(manager);
    }

    Registry<ConnectionSocketFactory> createConfiguredRegistry() {
        if (this.registry != null) {
            return this.registry;
        }
        TlsConfiguration tlsConfiguration = this.configuration.getTlsConfiguration();
        if (tlsConfiguration == null && this.verifier != null) {
            tlsConfiguration = new TlsConfiguration();
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = tlsConfiguration == null ? SSLConnectionSocketFactory.getSocketFactory() : new DropwizardSSLConnectionSocketFactory(tlsConfiguration, this.verifier).getSocketFactory();
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
    }

    protected InstrumentedHttpClientConnectionManager configureConnectionManager(InstrumentedHttpClientConnectionManager connectionManager) {
        connectionManager.setDefaultMaxPerRoute(this.configuration.getMaxConnectionsPerRoute());
        connectionManager.setMaxTotal(this.configuration.getMaxConnections());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.of((java.time.Duration)this.configuration.getConnectionTimeout().toJavaDuration())).setValidateAfterInactivity(TimeValue.of((java.time.Duration)this.configuration.getValidateAfterInactivityPeriod().toJavaDuration())).build();
        connectionManager.setConnectionConfigResolver(route -> connectionConfig);
        return connectionManager;
    }

    protected Credentials configureCredentials(AuthConfiguration auth) {
        if (null != auth.getCredentialType() && auth.getCredentialType().equalsIgnoreCase("NT")) {
            return new NTCredentials(auth.getUsername(), auth.getPassword().toCharArray(), auth.getHostname(), auth.getDomain());
        }
        return new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword().toCharArray());
    }
}

