/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.serial.adapter;

import io.doov.core.FieldInfo;
import io.doov.core.serial.TypeAdapter;
import java.util.Date;

public class DateTypeAdapter
implements TypeAdapter {
    @Override
    public boolean accept(FieldInfo info) {
        return Date.class.equals(info.type());
    }

    @Override
    public boolean accept(Object value) {
        return value instanceof Date;
    }

    @Override
    public String toString(Object value) {
        Date date = (Date)value;
        int day = date.getDate();
        int month = date.getMonth() + 1;
        int year = date.getYear() + 1900;
        return String.valueOf(year) + (month < 10 ? "0" + month : Integer.valueOf(month)) + (day < 10 ? "0" + day : Integer.valueOf(day));
    }

    @Override
    public Object fromString(FieldInfo info, String value) {
        int year = Integer.parseInt(value.substring(0, 4));
        int month = Integer.parseInt(value.substring(4, 6));
        int day = Integer.parseInt(value.substring(6, 8));
        Date date = new Date();
        date.setDate(day);
        date.setMonth(month - 1);
        date.setYear(year - 1900);
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        return date;
    }
}

