/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.time;

import io.doov.core.dsl.impl.time.LocalDateFunction;
import io.doov.core.dsl.impl.time.TemporalFunction;
import io.doov.core.dsl.meta.function.TemporalFunctionMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Optional;

public class LocalDateSuppliers {
    private static ThreadLocal<Clock> THREAD_CLOCK = new ThreadLocal();

    private LocalDateSuppliers() {
    }

    public static Clock createClockFrom(LocalDate localDate) {
        LocalDateTime time = LocalDateTime.of(localDate, LocalTime.of(0, 0));
        return Clock.fixed(time.atZone(ZoneId.systemDefault()).toInstant(), ZoneId.systemDefault());
    }

    public static boolean isClockSet() {
        return THREAD_CLOCK.get() != null;
    }

    public static void setClock(Clock clock) {
        THREAD_CLOCK.set(clock);
    }

    public static Clock getClock() {
        return LocalDateSuppliers.isClockSet() ? THREAD_CLOCK.get() : Clock.systemDefaultZone();
    }

    public static void setDefaultClock() {
        THREAD_CLOCK.remove();
    }

    public static TemporalFunction<LocalDate> today() {
        return new LocalDateFunction((PredicateMetadata)TemporalFunctionMetadata.todayMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock())));
    }

    public static TemporalFunction<LocalDate> todayPlus(int amountToAdd, TemporalUnit unit) {
        return new LocalDateFunction((PredicateMetadata)TemporalFunctionMetadata.todayPlusMetadata(amountToAdd, unit), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).plus(amountToAdd, unit)));
    }

    public static TemporalFunction<LocalDate> todayPlusDays(int daysToAdd) {
        return LocalDateSuppliers.todayPlus(daysToAdd, ChronoUnit.DAYS);
    }

    public static TemporalFunction<LocalDate> todayPlusYears(int yearsToAdd) {
        return LocalDateSuppliers.todayPlus(yearsToAdd, ChronoUnit.YEARS);
    }

    public static TemporalFunction<LocalDate> todayMinus(int amountToSubstract, TemporalUnit unit) {
        return new LocalDateFunction((PredicateMetadata)TemporalFunctionMetadata.todayMinusMetadata(amountToSubstract, unit), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).minus(amountToSubstract, unit)));
    }

    public static TemporalFunction<LocalDate> todayMinusDays(int daysToSubstract) {
        return LocalDateSuppliers.todayMinus(daysToSubstract, ChronoUnit.DAYS);
    }

    public static TemporalFunction<LocalDate> todayMinusYears(int yearsToSubstract) {
        return LocalDateSuppliers.todayMinus(yearsToSubstract, ChronoUnit.YEARS);
    }

    public static TemporalFunction<LocalDate> firstDayOfThisMonth() {
        return new LocalDateFunction((PredicateMetadata)TemporalFunctionMetadata.firstDayOfThisMonthMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).with(TemporalAdjusters.firstDayOfMonth())));
    }

    public static TemporalFunction<LocalDate> firstDayOfThisYear() {
        return new LocalDateFunction((PredicateMetadata)TemporalFunctionMetadata.firstDayOfThisYearMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).with(TemporalAdjusters.firstDayOfYear())));
    }

    public static TemporalFunction<LocalDate> lastDayOfThisMonth() {
        return new LocalDateFunction((PredicateMetadata)TemporalFunctionMetadata.lastDayOfThisMonthMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).with(TemporalAdjusters.lastDayOfMonth())));
    }

    public static TemporalFunction<LocalDate> lastDayOfThisYear() {
        return new LocalDateFunction((PredicateMetadata)TemporalFunctionMetadata.lastDayOfThisYearMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).with(TemporalAdjusters.lastDayOfYear())));
    }

    public static TemporalFunction<LocalDate> date(int year, int month, int dayOfMonth) {
        return new LocalDateFunction((PredicateMetadata)TemporalFunctionMetadata.dateMetadata(LocalDate.of(year, month, dayOfMonth)), (model, context) -> Optional.of(LocalDate.of(year, month, dayOfMonth)));
    }
}

