/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.runtime;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.dsl.runtime.RuntimeField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RuntimeFieldRegistry<M> {
    private final List<RuntimeField<M, Object>> runtimeFields = new ArrayList<RuntimeField<M, Object>>();
    private final List<Class<?>> fieldIdTypes = new ArrayList();
    private final List<EnumMap<?, RuntimeField<M, Object>>> enumFieldMaps = new ArrayList();
    private final Map<FieldId, RuntimeField<M, Object>> nonEnumFieldMap = new HashMap<FieldId, RuntimeField<M, Object>>();

    public RuntimeFieldRegistry(List<RuntimeField<M, Object>> runtimeFieldList) {
        runtimeFieldList.stream().sorted(Comparator.comparing(r -> r.id().code())).peek(this.runtimeFields::add).collect(Collectors.groupingBy(r -> r.id().getClass())).forEach((c, fields) -> {
            if (c.isEnum()) {
                this.fieldIdTypes.add((Class<?>)c);
                EnumMap enumMap = new EnumMap(c);
                fields.forEach(f -> enumMap.put((Enum)((Object)f.id()), f));
                this.enumFieldMaps.add(enumMap);
            } else {
                fields.forEach(f -> this.nonEnumFieldMap.put(f.id(), (RuntimeField<M, Object>)f));
            }
        });
    }

    public List<FieldInfo> fieldInfos() {
        return this.runtimeFields;
    }

    public List<RuntimeField<M, Object>> runtimeFields() {
        return this.runtimeFields;
    }

    public Stream<RuntimeField<M, Object>> stream() {
        return this.runtimeFields.stream();
    }

    public RuntimeField<M, Object> get(FieldId fieldId) {
        int classIndex = -1;
        for (int i = 0; i < this.fieldIdTypes.size(); ++i) {
            Class<?> type = this.fieldIdTypes.get(i);
            if (fieldId.getClass() != type) continue;
            classIndex = i;
            break;
        }
        if (classIndex >= 0) {
            return this.enumFieldMaps.get(classIndex).get(fieldId);
        }
        return this.nonEnumFieldMap.getOrDefault(fieldId, null);
    }
}

