/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.i18n;

import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;

public enum ResourceBundleProvider implements ResourceProvider
{
    BUNDLE;

    private final List<String> providers = new CopyOnWriteArrayList<String>();

    private ResourceBundleProvider() {
        this.register("io.doov.core.dsl.meta.i18n.DefaultResourceBundle");
    }

    public void register(String bundleBaseName) {
        if (!this.providers.contains(bundleBaseName)) {
            this.providers.add(bundleBaseName);
        }
    }

    @Override
    public String get(Operator operator, Locale locale) {
        return this.providers.stream().map(name -> this.getString(operator.name(), locale, (String)name)).filter(Objects::nonNull).findFirst().orElse(operator.readable());
    }

    @Override
    public String get(String key, Locale locale) {
        return this.providers.stream().map(name -> this.getString(key, locale, (String)name)).filter(Objects::nonNull).findFirst().orElse(key);
    }

    private String getString(String key, Locale locale, String name) {
        if (key == null) {
            return null;
        }
        try {
            return ResourceBundle.getBundle(name, locale).getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

