/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.function;

import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.concurrent.atomic.AtomicInteger;

public class TemporalFunctionMetadata
extends LeafMetadata<TemporalFunctionMetadata>
implements PredicateMetadata {
    private final AtomicInteger evalTrue = new AtomicInteger();
    private final AtomicInteger evalFalse = new AtomicInteger();

    public TemporalFunctionMetadata(MetadataType type) {
        super(type);
    }

    @Override
    public AtomicInteger evalTrue() {
        return this.evalTrue;
    }

    @Override
    public AtomicInteger evalFalse() {
        return this.evalFalse;
    }

    TemporalFunctionMetadata temporalUnit(Object unit) {
        return (TemporalFunctionMetadata)this.add(unit == null ? null : new Element(() -> unit.toString().toLowerCase(), ElementType.TEMPORAL_UNIT));
    }

    public static TemporalFunctionMetadata todayMetadata() {
        return (TemporalFunctionMetadata)new TemporalFunctionMetadata(MetadataType.LEAF_VALUE).operator(DefaultOperator.today);
    }

    public static TemporalFunctionMetadata todayPlusMetadata(int value, Object unit) {
        return ((TemporalFunctionMetadata)((TemporalFunctionMetadata)new TemporalFunctionMetadata(MetadataType.LEAF_VALUE).operator(DefaultOperator.today_plus)).valueObject(value)).temporalUnit(unit);
    }

    public static TemporalFunctionMetadata todayMinusMetadata(int value, Object unit) {
        return ((TemporalFunctionMetadata)((TemporalFunctionMetadata)new TemporalFunctionMetadata(MetadataType.LEAF_VALUE).operator(DefaultOperator.today_minus)).valueObject(value)).temporalUnit(unit);
    }

    public static TemporalFunctionMetadata firstDayOfThisMonthMetadata() {
        return (TemporalFunctionMetadata)new TemporalFunctionMetadata(MetadataType.LEAF_VALUE).operator(DefaultOperator.first_day_of_this_month);
    }

    public static TemporalFunctionMetadata firstDayOfThisYearMetadata() {
        return (TemporalFunctionMetadata)new TemporalFunctionMetadata(MetadataType.LEAF_VALUE).operator(DefaultOperator.first_day_of_this_year);
    }

    public static TemporalFunctionMetadata lastDayOfThisMonthMetadata() {
        return (TemporalFunctionMetadata)new TemporalFunctionMetadata(MetadataType.LEAF_VALUE).operator(DefaultOperator.last_day_of_this_month);
    }

    public static TemporalFunctionMetadata lastDayOfThisYearMetadata() {
        return (TemporalFunctionMetadata)new TemporalFunctionMetadata(MetadataType.LEAF_VALUE).operator(DefaultOperator.last_day_of_this_year);
    }

    public static TemporalFunctionMetadata dateMetadata(Object date) {
        return (TemporalFunctionMetadata)new TemporalFunctionMetadata(MetadataType.LEAF_VALUE).valueString(date.toString());
    }
}

