/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MetadataType;
import java.util.function.Supplier;

public class StaticMetadata<T>
extends LeafMetadata<StaticMetadata<T>> {
    private final T value;
    private final Class<T> valueClass;

    private StaticMetadata(MetadataType type, T value) {
        super(type);
        this.value = value;
        this.valueClass = value != null ? value.getClass() : null;
    }

    public static <U> StaticMetadata<U> mappingLeaf(Supplier<U> valueSupplier) {
        return (StaticMetadata)new StaticMetadata<U>(MetadataType.MAPPING_LEAF, valueSupplier.get()).valueObject(valueSupplier.get());
    }

    public static <U> StaticMetadata<U> leaf(U value) {
        return (StaticMetadata)new StaticMetadata<U>(MetadataType.LEAF_VALUE, value).valueObject(value);
    }

    public T value() {
        return this.value;
    }

    public Class<T> valueClass() {
        return this.valueClass;
    }
}

