/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.impl.DefaultFunction;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.meta.AbstractMetadata;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public abstract class LeafMetadata<M extends LeafMetadata<M>>
extends AbstractMetadata {
    private static final Collector<CharSequence, ?, String> COLLECTOR_LIST = Collectors.joining(", ", " : ", "");
    private final MetadataType type;
    private final Deque<Element> elements;

    public LeafMetadata(MetadataType type) {
        this(new ArrayDeque<Element>(), type);
    }

    private LeafMetadata(Deque<Element> elements, MetadataType type) {
        this.elements = elements;
        this.type = type;
    }

    @Override
    public MetadataType type() {
        return this.type;
    }

    public Deque<Element> elements() {
        return this.elements;
    }

    public List<Element> elementsAsList() {
        return new ArrayList<Element>(this.elements);
    }

    public M valueReadable(Readable readable) {
        return this.add(readable == null ? null : new Element(readable, ElementType.VALUE));
    }

    public M field(DslField<?> readable) {
        return this.add(readable == null ? null : new Element(readable, ElementType.FIELD));
    }

    public M operator(Operator op) {
        return this.add(op == null ? null : new Element(op, ElementType.OPERATOR));
    }

    public M valueObject(Object readable) {
        if (readable == null) {
            return this.valueReadable(() -> "null");
        }
        if (readable instanceof String) {
            return this.valueString((String)readable);
        }
        if (readable instanceof Readable) {
            return this.valueReadable((Readable)readable);
        }
        return this.valueReadable(() -> String.valueOf(readable));
    }

    public M add(Element element) {
        if (element != null) {
            this.elements().add(element);
        }
        return (M)this;
    }

    public M valueString(String readable) {
        return this.add(readable == null ? null : new Element(() -> readable, ElementType.STRING_VALUE));
    }

    public M valueSupplier(Supplier<?> readable) {
        return this.add(readable == null ? null : new Element(() -> String.valueOf(readable.get()), ElementType.VALUE));
    }

    public M valueUnknown(String readable) {
        return this.add(readable == null ? null : new Element(() -> "-function- " + readable, ElementType.UNKNOWN));
    }

    public M valueCondition(DefaultFunction<?, ?> condition) {
        LeafMetadata conditionMetadata = (LeafMetadata)condition.getMetadata();
        conditionMetadata.elements().stream().forEach(e -> this.add((Element)e));
        return (M)this;
    }

    @Deprecated
    public M valueListReadable(Collection<? extends Readable> readables) {
        return this.add(readables == null || readables.isEmpty() ? null : new Element(() -> LeafMetadata.formatListReadable(readables), ElementType.VALUE));
    }

    public M valueListObject(Collection<?> readables) {
        Iterator<?> iterator = readables.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            this.valueObject(next);
            if (!iterator.hasNext()) continue;
            this.add(new Element(() -> ",", ElementType.VALUE));
        }
        return (M)this;
    }

    @Deprecated
    private static String formatListReadable(Collection<? extends Readable> readables) {
        return readables.stream().map(Readable::readable).collect(COLLECTOR_LIST);
    }

    @Deprecated
    private static String formatListObject(Collection<?> readables) {
        return readables.stream().map(Object::toString).collect(COLLECTOR_LIST);
    }
}

