/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.MappingOperator;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.StaticMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IterableMetadata<E, T extends Iterable<E>>
extends NaryMetadata {
    private final MetadataType type;

    public IterableMetadata(MetadataType type, Operator operator, T values) {
        super(operator, StreamSupport.stream(values.spliterator(), false).map(StaticMetadata::leaf).collect(Collectors.toList()));
        this.type = type;
    }

    public static <T> IterableMetadata<T, Collection<T>> anyMatchMetadata(Collection<T> values) {
        return new IterableMetadata(MetadataType.FIELD_PREDICATE_MATCH_ANY, DefaultOperator.any_match_values, values);
    }

    public static <T> IterableMetadata<T, Collection<T>> noneMatchMetadata(Collection<T> values) {
        return new IterableMetadata(MetadataType.FIELD_PREDICATE_MATCH_ANY, DefaultOperator.none_match_values, values);
    }

    public static <T> IterableMetadata<T, Collection<T>> allMatchMetadata(Collection<T> values) {
        return new IterableMetadata(MetadataType.FIELD_PREDICATE_MATCH_ANY, DefaultOperator.all_match_values, values);
    }

    public static IterableMetadata<Readable, Collection<Readable>> anyMatchMetadataPredicates(String ... readables) {
        return new IterableMetadata(MetadataType.FIELD_PREDICATE_MATCH_ANY, DefaultOperator.any_match_predicates, Arrays.stream(readables).map(r -> () -> r).collect(Collectors.toList()));
    }

    public static <V, U extends Iterable<V>> IterableMetadata<V, U> mappingIterableMetadata(Supplier<U> valueSupplier) {
        return new IterableMetadata(MetadataType.MAPPING_LEAF_ITERABLE, MappingOperator.map, (Iterable)valueSupplier.get());
    }

    @Override
    public MetadataType type() {
        return this.type;
    }
}

