/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldModel;
import io.doov.core.dsl.impl.DefaultContext;
import io.doov.core.dsl.lang.AbstractDSLBuilder;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.DSLBuilder;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.meta.MappingRegistryMetadata;
import io.doov.core.dsl.meta.Metadata;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MappingRegistry
extends AbstractDSLBuilder
implements MappingRule {
    private final List<MappingRule> mappingRules;
    private final MappingRegistryMetadata metadata;

    public static MappingRegistry mappings(MappingRule ... mappingRules) {
        return new MappingRegistry(mappingRules);
    }

    private MappingRegistry(MappingRule ... mappingRules) {
        this.mappingRules = Arrays.asList(mappingRules);
        this.metadata = MappingRegistryMetadata.mappings(this.stream().map(DSLBuilder::metadata).collect(Collectors.toList()));
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    public MappingRegistry with(MappingRule ... rulestoAdd) {
        return new MappingRegistry((MappingRule[])Stream.concat(this.mappingRules.stream(), Arrays.stream(rulestoAdd)).toArray(MappingRule[]::new));
    }

    public Context validateAndExecute(FieldModel inModel, FieldModel outModel) {
        DefaultContext context = new DefaultContext(this.metadata());
        this.mappingRules.stream().filter(m -> m.validate(inModel, outModel)).forEach(m -> m.executeOn(inModel, outModel, context));
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Context> C validateAndExecute(FieldModel inModel, FieldModel outModel, C context) {
        context.beforeMappingRegistry(this);
        try {
            this.mappingRules.stream().filter(m -> m.validate(inModel, outModel)).forEach(m -> m.executeOn(inModel, outModel, context));
        }
        finally {
            context.afterMappingRegistry(this);
        }
        return context;
    }

    public boolean isEmpty() {
        return this.mappingRules.isEmpty();
    }

    @Override
    public boolean validate(FieldModel inModel, FieldModel outModel) {
        return this.mappingRules.stream().allMatch(m -> m.validate(inModel, outModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Context> C executeOn(FieldModel inModel, FieldModel outModel, C context) {
        context.beforeMappingRegistry(this);
        try {
            this.mappingRules.forEach(rule -> rule.executeOn(inModel, outModel, context));
        }
        finally {
            context.afterMappingRegistry(this);
        }
        return context;
    }

    @Override
    public <C extends Context> C executeOn(FieldModel model, C context) {
        return this.executeOn(model, model, context);
    }

    @Override
    public Context executeOn(FieldModel inModel, FieldModel outModel) {
        return this.executeOn(inModel, outModel, new DefaultContext(this.metadata()));
    }

    @Override
    public Context executeOn(FieldModel model) {
        return this.executeOn(model, model, new DefaultContext(this.metadata()));
    }

    @Override
    public Stream<MappingRule> stream() {
        return this.mappingRules.stream();
    }
}

