/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldModel;
import io.doov.core.dsl.impl.DefaultContext;
import io.doov.core.dsl.lang.AbstractDSLBuilder;
import io.doov.core.dsl.lang.ConditionalMappingRule;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.DSLBuilder;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.mapping.MappingRegistry;
import io.doov.core.dsl.meta.ConditionalMappingMetadata;
import io.doov.core.dsl.meta.MappingRegistryMetadata;
import io.doov.core.dsl.meta.Metadata;
import java.util.stream.Collectors;

public class DefaultConditionalMappingRule
extends AbstractDSLBuilder
implements ConditionalMappingRule {
    private final ConditionalMappingMetadata metadata;
    private final StepWhen stepWhen;
    private final ValidationRule validationRule;
    private final MappingRegistry mappingRules;
    private final MappingRegistry elseMappingRules;

    public DefaultConditionalMappingRule(StepWhen stepWhen, MappingRule ... mappingRules) {
        this(stepWhen, mappingRules, new MappingRule[0]);
    }

    private DefaultConditionalMappingRule(StepWhen stepWhen, MappingRule[] thenRules, MappingRule[] elseRules) {
        this.stepWhen = stepWhen;
        this.validationRule = stepWhen.validate();
        this.mappingRules = MappingRegistry.mappings(thenRules);
        this.elseMappingRules = MappingRegistry.mappings(elseRules);
        this.metadata = ConditionalMappingMetadata.conditional(stepWhen.metadata(), MappingRegistryMetadata.then(this.mappingRules.stream().map(DSLBuilder::metadata).collect(Collectors.toList())), MappingRegistryMetadata.otherwise(this.elseMappingRules.stream().map(DSLBuilder::metadata).collect(Collectors.toList())));
    }

    private DefaultConditionalMappingRule(StepWhen stepWhen, MappingRegistry thenRules, MappingRule[] elseRules) {
        this.stepWhen = stepWhen;
        this.validationRule = stepWhen.validate();
        this.mappingRules = thenRules;
        this.elseMappingRules = MappingRegistry.mappings(elseRules);
        this.metadata = ConditionalMappingMetadata.conditional(stepWhen.metadata(), MappingRegistryMetadata.then(this.mappingRules.stream().map(DSLBuilder::metadata).collect(Collectors.toList())), MappingRegistryMetadata.otherwise(this.elseMappingRules.stream().map(DSLBuilder::metadata).collect(Collectors.toList())));
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public ValidationRule validation() {
        return this.validationRule;
    }

    @Override
    public ConditionalMappingRule otherwise(MappingRule ... elseRules) {
        return new DefaultConditionalMappingRule(this.stepWhen, this.mappingRules, elseRules);
    }

    @Override
    public boolean validate(FieldModel inModel, FieldModel outModel) {
        return this.mappingRules.validate(inModel, outModel) && this.elseMappingRules.validate(inModel, outModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Context> C executeOn(FieldModel inModel, FieldModel outModel, C context) {
        context.beforeConditionalMapping(this);
        try {
            if (this.validationRule.executeOn(inModel, context).value()) {
                this.mappingRules.executeOn(inModel, outModel, context);
            } else if (!this.elseMappingRules.isEmpty()) {
                this.elseMappingRules.executeOn(inModel, outModel, context);
            }
        }
        finally {
            context.afterConditionalMapping(this);
        }
        return context;
    }

    @Override
    public <C extends Context> C executeOn(FieldModel model, C context) {
        return this.executeOn(model, model, context);
    }

    @Override
    public Context executeOn(FieldModel inModel, FieldModel outModel) {
        return this.executeOn(inModel, outModel, new DefaultContext(this.metadata));
    }

    @Override
    public Context executeOn(FieldModel model) {
        return this.executeOn(model, model);
    }
}

