/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl.time;

import io.doov.core.dsl.impl.time.TemporalOperators;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalUnit;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface LocalDateTimeOperators
extends TemporalOperators<LocalDateTime> {
    @Override
    default public Function<LocalDateTime, LocalDateTime> minusFunction(int value, TemporalUnit unit) {
        return dateTime -> dateTime.minus(value, unit);
    }

    @Override
    default public Function<LocalDateTime, LocalDateTime> plusFunction(int value, TemporalUnit unit) {
        return dateTime -> dateTime.plus(value, unit);
    }

    @Override
    default public Function<LocalDateTime, LocalDateTime> withFunction(TemporalAdjuster ajuster) {
        return dateTime -> dateTime.with(ajuster);
    }

    @Override
    default public BiFunction<LocalDateTime, LocalDateTime, Boolean> afterFunction() {
        return LocalDateTime::isAfter;
    }

    @Override
    default public BiFunction<LocalDateTime, LocalDateTime, Boolean> afterOrEqualsFunction() {
        return (dateTime1, dateTime2) -> dateTime1.isAfter((ChronoLocalDateTime<?>)dateTime2) || dateTime1.equals(dateTime2);
    }

    @Override
    default public BiFunction<LocalDateTime, LocalDateTime, Boolean> beforeFunction() {
        return LocalDateTime::isBefore;
    }

    @Override
    default public BiFunction<LocalDateTime, LocalDateTime, Boolean> beforeOrEqualsFunction() {
        return (dateTime1, dateTime2) -> dateTime1.isBefore((ChronoLocalDateTime<?>)dateTime2) || dateTime1.equals(dateTime2);
    }

    @Override
    default public BiFunction<LocalDateTime, LocalDateTime, Long> betweenFunction(ChronoUnit unit) {
        return unit::between;
    }
}

