/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.FieldId;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.Metadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultContext
implements Context {
    private final List<Metadata> evalTrue = new ArrayList<Metadata>();
    private final List<Metadata> evalFalse = new ArrayList<Metadata>();
    private final Map<FieldId, Object> values = new HashMap<FieldId, Object>();
    private final boolean shortCircuit;
    private Metadata rootMetadata;

    public DefaultContext(Metadata rootMetadata) {
        this(true, rootMetadata);
    }

    public DefaultContext(boolean shortCircuit, Metadata rootMetadata) {
        this.shortCircuit = shortCircuit;
        this.rootMetadata = rootMetadata;
    }

    @Override
    public Metadata getRootMetadata() {
        return this.rootMetadata;
    }

    @Override
    public boolean isEvalTrue(Metadata metadata) {
        return this.evalTrue.contains(metadata);
    }

    @Override
    public boolean isEvalFalse(Metadata metadata) {
        return this.evalFalse.contains(metadata);
    }

    @Override
    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    @Override
    public void addEvalTrue(Metadata metadata) {
        this.evalTrue.add(metadata);
    }

    @Override
    public void addEvalFalse(Metadata metadata) {
        this.evalFalse.add(metadata);
    }

    @Override
    public void addEvalValue(FieldId id, Object value) {
        this.values.put(id, value);
    }

    @Override
    public void addSetValue(FieldId id, Object value) {
        this.values.put(id, value);
    }

    @Override
    public Object getEvalValue(FieldId id) {
        return this.values.get(id);
    }

    @Override
    public List<Metadata> getEvalTrue() {
        return Collections.unmodifiableList(this.evalTrue);
    }

    @Override
    public List<Metadata> getEvalFalse() {
        return Collections.unmodifiableList(this.evalFalse);
    }

    @Override
    public Map<FieldId, Object> getEvalValues() {
        return Collections.unmodifiableMap(this.values);
    }
}

