/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.field;

import io.doov.core.TagId;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.field.types.Function;
import io.doov.core.dsl.impl.DefaultFunction;
import io.doov.core.dsl.impl.base.IterableFunction;
import io.doov.core.dsl.impl.base.StringFunction;
import io.doov.core.dsl.impl.num.IntegerFunction;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.function.MapFunctionMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface BaseFieldInfo<T>
extends DslField<T> {
    default public StepCondition isNull() {
        return this.getDefaultFunction().isNull();
    }

    default public StepCondition isNotNull() {
        return this.getDefaultFunction().isNotNull();
    }

    default public StepCondition eq(T value) {
        return this.getDefaultFunction().eq(value);
    }

    default public StepCondition eq(BaseFieldInfo<T> value) {
        return this.getDefaultFunction().eq(value);
    }

    @Deprecated
    default public StepCondition eq(Supplier<T> supplier) {
        return this.getDefaultFunction().eq(supplier);
    }

    default public StepCondition eq(Function<T> function) {
        return this.getDefaultFunction().eq(function);
    }

    default public StepCondition notEq(T value) {
        return this.getDefaultFunction().notEq(value);
    }

    default public StepCondition notEq(BaseFieldInfo<T> value) {
        return this.getDefaultFunction().notEq(value);
    }

    @Deprecated
    default public StepCondition notEq(Supplier<T> supplier) {
        return this.getDefaultFunction().notEq(supplier);
    }

    default public StepCondition notEq(Function<T> function) {
        return this.getDefaultFunction().notEq(function);
    }

    default public StepCondition anyMatch(Predicate<T> value, String ... readables) {
        return this.getDefaultFunction().anyMatch(Collections.singletonList(value), readables);
    }

    default public StepCondition anyMatch(T ... values) {
        return this.getDefaultFunction().anyMatch((Collection<T>)Arrays.asList(values));
    }

    default public StepCondition anyMatch(Collection<T> values) {
        return this.getDefaultFunction().anyMatch(values);
    }

    default public StepCondition allMatch(Predicate<T> value, String ... readable) {
        return this.getDefaultFunction().allMatch(Collections.singletonList(value), readable);
    }

    default public StepCondition allMatch(T ... values) {
        return this.getDefaultFunction().allMatch((Collection<T>)Arrays.asList(values));
    }

    default public StepCondition allMatch(Collection<T> values) {
        return this.getDefaultFunction().allMatch(values);
    }

    default public StepCondition noneMatch(Predicate<T> value, String ... readable) {
        return this.getDefaultFunction().noneMatch(Collections.singletonList(value), readable);
    }

    default public StepCondition noneMatch(T ... values) {
        return this.getDefaultFunction().noneMatch((Collection<T>)Arrays.asList(values));
    }

    default public StepCondition noneMatch(Collection<T> values) {
        return this.getDefaultFunction().noneMatch(values);
    }

    @Deprecated
    default public IntegerFunction mapToInt(java.util.function.Function<T, Integer> mapper) {
        return this.getDefaultFunction().mapToInt(mapper);
    }

    default public IntegerFunction mapToInt(String readable, java.util.function.Function<T, Integer> mapper) {
        return this.getDefaultFunction().mapToInt(readable, mapper);
    }

    @Deprecated
    default public StringFunction mapToString(java.util.function.Function<T, String> mapper) {
        return this.getDefaultFunction().mapToString(mapper);
    }

    default public StringFunction mapToString(String readable, java.util.function.Function<T, String> mapper) {
        return this.getDefaultFunction().mapToString(readable, mapper);
    }

    default public <R> DefaultFunction<R, MapFunctionMetadata> map(String readable, java.util.function.Function<T, R> mapper) {
        return this.getDefaultFunction().map(readable, mapper);
    }

    default public <U, R> DefaultFunction<R, MapFunctionMetadata> mapUsing(String readable, DslField<U> condition, BiFunction<T, U, R> mapper) {
        return this.getDefaultFunction().mapUsing(readable, condition.getDefaultFunction(), mapper);
    }

    default public StepCondition hasTag(TagId tag) {
        return this.getDefaultFunction().tags().contains(tag);
    }

    default public IterableFunction<TagId, List<TagId>> tags() {
        return this.getDefaultFunction().tags();
    }

    default public IntegerFunction position() {
        return this.getDefaultFunction().position();
    }
}

