/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.PredicateMetadata;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class UnaryMetadata
extends PredicateMetadata {
    private final Operator operator;
    private final Metadata value;

    private UnaryMetadata(Operator operator, Metadata value) {
        this.operator = operator;
        this.value = value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public static UnaryMetadata notMetadata(Metadata value) {
        return new UnaryMetadata(DefaultOperator.not, value);
    }

    @Override
    public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale);
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.visit(this, depth);
        this.value.accept(visitor, depth + 1);
        visitor.end(this, depth);
    }

    @Override
    public List<Element> flatten() {
        ArrayList<Element> flatten = new ArrayList<Element>();
        flatten.add(new Element(this.operator, ElementType.OPERATOR));
        flatten.addAll(this.value.flatten());
        return flatten;
    }

    @Override
    public List<Metadata> children() {
        return Arrays.asList(this.value);
    }

    @Override
    public MetadataType type() {
        return MetadataType.UNARY_PREDICATE;
    }

    @Override
    public Metadata message(Context context) {
        if (this.operator == DefaultOperator.not) {
            return this;
        }
        return new UnaryMetadata(this.operator, this.value.message(context));
    }
}

