/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.MetadataVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class ConverterMetadata
implements Metadata {
    private final Element element;
    private final MetadataType type;

    public ConverterMetadata(Element element, MetadataType type) {
        this.element = element;
        this.type = type;
    }

    public static ConverterMetadata metadata(String description) {
        return new ConverterMetadata(new Element(() -> Optional.ofNullable(description).filter(d -> !d.isEmpty()).orElse("-function-"), ElementType.STRING_VALUE), MetadataType.TYPE_CONVERTER);
    }

    public static ConverterMetadata identity() {
        return new ConverterMetadata(new Element(() -> "identity", ElementType.STRING_VALUE), MetadataType.TYPE_CONVERTER_IDENTITY);
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        if (this.type != MetadataType.TYPE_CONVERTER_IDENTITY) {
            visitor.start(this, depth);
            visitor.visit(this, depth);
            visitor.end(this, depth);
        }
    }

    @Override
    public List<Element> flatten() {
        return Collections.singletonList(this.element);
    }

    @Override
    public List<Metadata> children() {
        return Collections.emptyList();
    }

    @Override
    public String readable(Locale locale) {
        return this.element.getReadable().readable();
    }

    @Override
    public MetadataType type() {
        return this.type;
    }

    @Override
    public Metadata message(Context context) {
        return this;
    }
}

