/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldModel;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.lang.NaryTypeConverter;
import io.doov.core.dsl.meta.MappingMetadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.List;
import java.util.Locale;

public class NaryMappingRule<O>
implements MappingRule {
    private final MappingMetadata metadata;
    private final List<DslField> fieldInfos;
    private final DslField<O> outFieldInfo;
    private final NaryTypeConverter<O> typeConverter;

    NaryMappingRule(List<DslField> fieldInfos, DslField<O> outFieldInfo, NaryTypeConverter<O> typeConverter) {
        this.fieldInfos = fieldInfos;
        this.outFieldInfo = outFieldInfo;
        this.metadata = MappingMetadata.mapping(fieldInfos, outFieldInfo);
        this.typeConverter = typeConverter;
    }

    @Override
    public boolean validate(FieldModel inModel, FieldModel outModel) {
        return this.fieldInfos.stream().allMatch(f -> inModel.getFieldInfos().stream().anyMatch(i -> i.id().equals(f.id()))) && outModel.getFieldInfos().stream().anyMatch(f -> f.id().equals(this.outFieldInfo.id()));
    }

    @Override
    public void executeOn(FieldModel inModel, FieldModel outModel) {
        outModel.set(this.outFieldInfo.id(), this.typeConverter.convert(inModel, this.fieldInfos.toArray(new DslField[0])));
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        this.metadata.accept(visitor, depth);
        this.typeConverter.accept(visitor, depth);
    }

    @Override
    public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale);
    }
}

