/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldModel;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.lang.BiTypeConverter;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.meta.MappingMetadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.Arrays;
import java.util.Locale;

public class BiMappingRule<I, J, O>
implements MappingRule {
    private final DslField<I> inFieldInfo;
    private final DslField<J> in2FieldInfo;
    private final MappingMetadata metadata;
    private final DslField<O> outFieldInfo;
    private final BiTypeConverter<I, J, O> typeConverter;

    BiMappingRule(DslField<I> inFieldInfo, DslField<J> in2FieldInfo, DslField<O> outFieldInfo, BiTypeConverter<I, J, O> typeConverter) {
        this.inFieldInfo = inFieldInfo;
        this.in2FieldInfo = in2FieldInfo;
        this.metadata = MappingMetadata.mapping(Arrays.asList(inFieldInfo, in2FieldInfo), outFieldInfo);
        this.outFieldInfo = outFieldInfo;
        this.typeConverter = typeConverter;
    }

    @Override
    public boolean validate(FieldModel inModel, FieldModel outModel) {
        return inModel.getFieldInfos().stream().anyMatch(f -> f.id().equals(this.inFieldInfo.id())) && inModel.getFieldInfos().stream().anyMatch(f -> f.id().equals(this.in2FieldInfo.id())) && outModel.getFieldInfos().stream().anyMatch(f -> f.id().equals(this.outFieldInfo.id()));
    }

    @Override
    public void executeOn(FieldModel inModel, FieldModel outModel) {
        outModel.set(this.outFieldInfo.id(), this.typeConverter.convert(inModel, this.inFieldInfo, this.in2FieldInfo));
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        this.metadata.accept(visitor, depth);
        this.typeConverter.accept(visitor, depth);
    }

    @Override
    public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale);
    }
}

