/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.impl.TemporalCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalUnit;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class LocalTimeCondition
extends TemporalCondition<LocalTime> {
    public LocalTimeCondition(DslField field) {
        super(field);
    }

    public LocalTimeCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<LocalTime>> value) {
        super(field, metadata, value);
    }

    @Override
    protected TemporalCondition<LocalTime> temporalCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<LocalTime>> value) {
        return new LocalTimeCondition(field, metadata, value);
    }

    @Override
    Function<LocalTime, LocalTime> minusFunction(int value, TemporalUnit unit) {
        return time -> time.minus(value, unit);
    }

    @Override
    Function<LocalTime, LocalTime> plusFunction(int value, TemporalUnit unit) {
        return time -> time.plus(value, unit);
    }

    @Override
    Function<LocalTime, LocalTime> withFunction(TemporalAdjuster ajuster) {
        return time -> time.with(ajuster);
    }

    @Override
    BiFunction<LocalTime, LocalTime, Boolean> afterFunction() {
        return LocalTime::isAfter;
    }

    @Override
    BiFunction<LocalTime, LocalTime, Boolean> afterOrEqualsFunction() {
        return (time1, time2) -> time1.isAfter((LocalTime)time2) || time1.equals(time2);
    }

    @Override
    BiFunction<LocalTime, LocalTime, Boolean> beforeFunction() {
        return LocalTime::isBefore;
    }

    @Override
    BiFunction<LocalTime, LocalTime, Boolean> beforeOrEqualsFunction() {
        return (time1, time2) -> time1.isBefore((LocalTime)time2) || time1.equals(time2);
    }

    @Override
    BiFunction<LocalTime, LocalTime, Long> betweenFunction(ChronoUnit unit) {
        return unit::between;
    }
}

