/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.PathValueOperation;
import com.google.common.collect.Iterables;

public final class ReplaceOperation
extends PathValueOperation {
    public static final String OPERATION_NAME = "replace";

    @JsonCreator
    public ReplaceOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super(OPERATION_NAME, path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (((JsonNode)this.getPath().path((TreeNode)node)).isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        JsonNode replacement = this.value.deepCopy();
        if (this.getPath().isEmpty()) {
            return replacement;
        }
        JsonNode ret = node.deepCopy();
        JsonNode parent = (JsonNode)this.getPath().parent().get((TreeNode)ret);
        String rawToken = ((TokenResolver)Iterables.getLast((Iterable)this.getPath())).getToken().getRaw();
        if (parent.isObject()) {
            ((ObjectNode)parent).put(rawToken, replacement);
        } else {
            ((ArrayNode)parent).set(Integer.parseInt(rawToken), replacement);
        }
        return ret;
    }
}

