/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.AddOperation;
import com.github.fge.jsonpatch.operation.DualPathOperation;
import com.github.fge.jsonpatch.operation.RemoveOperation;
import com.github.fge.jsonpatch.operation.policy.PathMissingPolicy;

public abstract class MoveOperationBase
extends DualPathOperation {
    private final PathMissingPolicy pathMissingPolicy;

    @JsonCreator
    public MoveOperationBase(String op, @JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path, PathMissingPolicy pathMissingPolicy) {
        super(op, from, path);
        this.pathMissingPolicy = pathMissingPolicy;
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode ret = node.deepCopy();
        if (this.from.equals((Object)this.getPath())) {
            return ret;
        }
        JsonNode movedNode = (JsonNode)this.from.path((TreeNode)node);
        if (movedNode.isMissingNode()) {
            switch (this.pathMissingPolicy) {
                case THROW: {
                    throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
                }
                case SKIP: {
                    return ret;
                }
            }
        }
        RemoveOperation remove = new RemoveOperation(this.from);
        AddOperation add = new AddOperation(this.getPath(), movedNode);
        return add.apply(remove.apply(node));
    }
}

