/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.digdag.core.session.TaskRelation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TaskTree {
    private final Map<Long, TaskRelation> map;
    private final Map<Long, List<TaskRelation>> parentIdToSortedChildren;

    public TaskTree(List<TaskRelation> rels) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TaskRelation rel2 : rels) {
            builder.put((Object)rel2.getId(), (Object)rel2);
        }
        this.map = builder.build();
        this.parentIdToSortedChildren = this.map.values().stream().filter(rel -> rel.getParentId().isPresent()).collect(Collectors.groupingBy(rel -> (Long)rel.getParentId().get(), Collectors.collectingAndThen(Collectors.toList(), siblings -> siblings.stream().sorted((a, b) -> Long.valueOf(a.getId()).compareTo(b.getId())).collect(Collectors.toList()))));
    }

    public long getRootTaskId() {
        for (TaskRelation rel : this.map.values()) {
            if (rel.getParentId().isPresent()) continue;
            return rel.getId();
        }
        throw new IllegalStateException("Root task doesn't exist in an attempt: " + this.map.values());
    }

    private TaskRelation get(long id) {
        return Objects.requireNonNull(this.map.get(id));
    }

    private Optional<TaskRelation> getParent(long id) {
        return this.get(id).getParentId().transform(it -> this.get((long)it));
    }

    public List<Long> getRecursiveParentIdListFromRoot(long id) {
        return this.walkParentsRecursively(id, ImmutableList.builder(), (builder, parent) -> builder.add((Object)parent.getId())).build();
    }

    private <T> T walkParentsRecursively(long id, T value, Walker<T> walker) {
        Optional<TaskRelation> parent = this.getParent(id);
        if (!parent.isPresent()) {
            return value;
        }
        value = this.walkParentsRecursively(((TaskRelation)parent.get()).getId(), value, walker);
        return walker.walk(value, (TaskRelation)parent.get());
    }

    public List<Long> getRecursiveParentsUpstreamChildrenIdListFromFar(long id) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.copyOf((Iterable)Iterables.concat(this.getRecursiveParentIdListFromRoot(id), (Iterable)ImmutableList.of((Object)id))).stream().forEach(parentId -> {
            this.walkUpstreamSiblings((long)parentId, (Object)builder, (sameBuilder1, sib) -> {
                sameBuilder1.add((Object)sib.getId());
                this.walkChildrenRecursively(sib.getId(), sameBuilder1, (sameBuilder2, child) -> sameBuilder2.add((Object)child.getId()));
                return builder;
            });
            if (parentId != id) {
                builder.add(parentId);
            }
        });
        return builder.build();
    }

    public <T> T walkChildrenRecursively(long id, T value, Walker<T> walker) {
        List<TaskRelation> sortedChildren = this.parentIdToSortedChildren.get(id);
        if (sortedChildren != null) {
            for (TaskRelation child : sortedChildren) {
                value = walker.walk(value, child);
                value = this.walkChildrenRecursively(child.getId(), value, walker);
            }
        }
        return value;
    }

    private <T> T walkUpstreamSiblings(long id, T value, Walker<T> walker) {
        return this.walkUpstreamSiblings(id, value, walker, new HashSet<Long>());
    }

    private <T> T walkUpstreamSiblings(long id, T value, Walker<T> walker, Set<Long> walkedSet) {
        TaskRelation rel = this.get(id);
        ImmutableSet upstreams = ImmutableSet.copyOf(rel.getUpstreams());
        if (upstreams.isEmpty()) {
            return value;
        }
        List<TaskRelation> sortedSiblings = this.parentIdToSortedChildren.get(rel.getParentId().get());
        for (TaskRelation sibling : sortedSiblings) {
            if (!upstreams.contains(sibling.getId()) || !walkedSet.add(sibling.getId())) continue;
            value = this.walkUpstreamSiblings(sibling.getId(), value, walker, walkedSet);
            value = walker.walk(value, sibling);
        }
        return value;
    }

    public List<Long> getRecursiveChildrenIdList(long id) {
        return this.walkChildrenRecursively(id, ImmutableList.builder(), (builder, child) -> builder.add((Object)child.getId())).build();
    }

    public static interface Walker<T> {
        public T walk(T var1, TaskRelation var2);
    }
}

