/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.google.common.collect.ImmutableList;
import io.digdag.core.workflow.WorkflowTask;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TaskMatchPattern {
    static final Pattern DELIMITER_PATTERN = Pattern.compile("(?![\\-\\=\\[\\]\\{\\}\\%\\&\\@\\,\\.\\_])(?=[\\W])", 256);
    private final String pattern;
    private final Pattern regex;

    public static TaskMatchPattern compile(String pattern) {
        String[] fragments = DELIMITER_PATTERN.split(pattern);
        if (fragments.length == 0) {
            throw new SyntaxException("Task match pattern is invalid: " + pattern);
        }
        for (String f : fragments) {
            if (f.length() != 1) continue;
            throw new SyntaxException("Match patterns excepting direct child (+name+name) is not supported: " + pattern);
        }
        return new TaskMatchPattern(pattern, fragments);
    }

    private TaskMatchPattern(String pattern, String[] fragments) {
        this.pattern = pattern;
        this.regex = Pattern.compile(".*" + Pattern.quote(pattern));
    }

    public String getPattern() {
        return this.pattern;
    }

    public int findIndex(List<WorkflowTask> tasks) throws MultipleTaskMatchException, NoMatchException {
        Map all = this.filter(new TaskFullNameResolver(tasks).resolve());
        this.ensureMatchOne(all.keySet());
        return ((WorkflowTask)all.values().iterator().next()).getIndex();
    }

    public <T> T find(Map<String, T> tasks) throws MultipleTaskMatchException, NoMatchException {
        Map<String, T> all = this.filter(tasks);
        this.ensureMatchOne(all.keySet());
        return all.values().iterator().next();
    }

    private <T> Map<String, T> filter(Map<String, T> fullNames) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (Map.Entry<String, T> pair : fullNames.entrySet()) {
            if (!this.regex.matcher(pair.getKey()).matches()) continue;
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    private void ensureMatchOne(Collection<String> matchedNames) throws MultipleTaskMatchException, NoMatchException {
        if (matchedNames.size() == 1) {
            return;
        }
        if (matchedNames.isEmpty()) {
            throw new NoMatchException(String.format("Task pattern '%s' doesn't match with any tasks.", this.pattern));
        }
        throw new MultipleTaskMatchException(String.format("Task pattern '%s' is ambiguous. Matching candidates are %s", this.pattern, matchedNames), (List<String>)ImmutableList.copyOf(matchedNames));
    }

    private static class TaskFullNameResolver {
        private final List<Entry> entries;

        public static Map<String, WorkflowTask> resolve(List<WorkflowTask> tasks) {
            return new TaskFullNameResolver(tasks).resolve();
        }

        private TaskFullNameResolver(List<WorkflowTask> tasks) {
            this.entries = tasks.stream().map(task -> new Entry((WorkflowTask)task)).collect(Collectors.toList());
        }

        private Map<String, WorkflowTask> resolve() {
            LinkedHashMap<String, WorkflowTask> map = new LinkedHashMap<String, WorkflowTask>();
            for (Entry entry : this.entries) {
                map.put(entry.getFullName(), entry.getTask());
            }
            return map;
        }

        private class Entry {
            private final WorkflowTask task;
            private String fullName;

            public Entry(WorkflowTask task) {
                this.task = task;
            }

            public String getFullName() {
                if (this.fullName == null) {
                    this.fullName = this.task.getParentIndex().isPresent() ? ((Entry)TaskFullNameResolver.this.entries.get((Integer)this.task.getParentIndex().get())).getFullName() + this.task.getName() : this.task.getName();
                }
                return this.fullName;
            }

            public WorkflowTask getTask() {
                return this.task;
            }
        }
    }

    public static class NoMatchException
    extends MatchException {
        public NoMatchException(String message) {
            super(message);
        }
    }

    public static class MultipleTaskMatchException
    extends MatchException {
        private final List<String> matches;

        public MultipleTaskMatchException(String message, List<String> matches) {
            super(message);
            this.matches = matches;
        }

        public List<String> getMatches() {
            return this.matches;
        }
    }

    public static class MatchException
    extends Exception {
        public MatchException(String message) {
            super(message);
        }
    }

    public static class SyntaxException
    extends RuntimeException {
        public SyntaxException(String message) {
            super(message);
        }
    }
}

