/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.digdag.client.config.Config;
import io.digdag.core.session.SessionAttempt;

public class TaskConfig {
    private final Config local;
    private final Config export;

    public static void validateAttempt(SessionAttempt attempt) {
    }

    public static TaskConfig validate(Config config) {
        Config copy = config.deepCopy();
        Config export = copy.getNestedOrGetEmpty("_export");
        copy.remove("_export");
        return new TaskConfig(copy, export);
    }

    @JsonCreator
    public static TaskConfig assumeValidated(@JsonProperty(value="local") Config local, @JsonProperty(value="export") Config export) {
        return new TaskConfig(local, export);
    }

    private TaskConfig(Config local, Config export) {
        this.local = local;
        this.export = export;
    }

    @JsonProperty(value="local")
    public Config getLocal() {
        return this.local;
    }

    @JsonProperty(value="export")
    public Config getExport() {
        return this.export;
    }

    @JsonIgnore
    public Config getMerged() {
        return this.export.deepCopy().merge(this.local);
    }

    @JsonIgnore
    public Config getNonValidated() {
        Config config = this.local.deepCopy();
        if (!this.export.isEmpty()) {
            config.set("_export", (Object)this.export);
        }
        return config;
    }

    @JsonIgnore
    public Config getCheckConfig() {
        return this.getMerged().getNestedOrGetEmpty("_check").deepCopy();
    }

    @JsonIgnore
    public Config getErrorConfig() {
        return this.getMerged().getNestedOrGetEmpty("_error").deepCopy();
    }

    private TaskConfig validate() {
        this.getCheckConfig();
        this.getErrorConfig();
        return this;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TaskConfig)) {
            return false;
        }
        TaskConfig o = (TaskConfig)other;
        return this.getNonValidated().equals((Object)o.getNonValidated());
    }

    public int hashCode() {
        return this.getNonValidated().hashCode();
    }

    public String toString() {
        return this.getNonValidated().toString();
    }
}

