/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.workflow.AttemptRequest;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStored
extends AttemptRequest.Stored {
    private final long workflowDefinitionId;
    private final int projectId;

    private ImmutableStored(long workflowDefinitionId, int projectId) {
        this.workflowDefinitionId = workflowDefinitionId;
        this.projectId = projectId;
    }

    @Override
    @JsonProperty(value="workflowDefinitionId")
    public long getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    @Override
    @JsonProperty(value="projectId")
    public int getProjectId() {
        return this.projectId;
    }

    public final ImmutableStored withWorkflowDefinitionId(long value) {
        if (this.workflowDefinitionId == value) {
            return this;
        }
        return new ImmutableStored(value, this.projectId);
    }

    public final ImmutableStored withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return new ImmutableStored(this.workflowDefinitionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStored && this.equalTo((ImmutableStored)another);
    }

    private boolean equalTo(ImmutableStored another) {
        return this.workflowDefinitionId == another.workflowDefinitionId && this.projectId == another.projectId;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.workflowDefinitionId);
        h = h * 17 + this.projectId;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Stored").omitNullValues().add("workflowDefinitionId", this.workflowDefinitionId).add("projectId", this.projectId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStored fromJson(Json json) {
        Builder builder = ImmutableStored.builder();
        if (json.workflowDefinitionIdIsSet) {
            builder.workflowDefinitionId(json.workflowDefinitionId);
        }
        if (json.projectIdIsSet) {
            builder.projectId(json.projectId);
        }
        return builder.build();
    }

    public static ImmutableStored copyOf(AttemptRequest.Stored instance) {
        if (instance instanceof ImmutableStored) {
            return (ImmutableStored)instance;
        }
        return ImmutableStored.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKFLOW_DEFINITION_ID = 1L;
        private static final long INIT_BIT_PROJECT_ID = 2L;
        private long initBits = 3L;
        private long workflowDefinitionId;
        private int projectId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AttemptRequest.Stored instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.workflowDefinitionId(instance.getWorkflowDefinitionId());
            this.projectId(instance.getProjectId());
            return this;
        }

        @JsonProperty(value="workflowDefinitionId")
        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="projectId")
        @CanIgnoreReturnValue
        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStored build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStored(this.workflowDefinitionId, this.projectId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workflowDefinitionId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectId");
            }
            return "Cannot build Stored, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AttemptRequest.Stored {
        long workflowDefinitionId;
        boolean workflowDefinitionIdIsSet;
        int projectId;
        boolean projectIdIsSet;

        Json() {
        }

        @JsonProperty(value="workflowDefinitionId")
        public void setWorkflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
            this.workflowDefinitionIdIsSet = true;
        }

        @JsonProperty(value="projectId")
        public void setProjectId(int projectId) {
            this.projectId = projectId;
            this.projectIdIsSet = true;
        }

        @Override
        public long getWorkflowDefinitionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProjectId() {
            throw new UnsupportedOperationException();
        }
    }
}

