/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum TaskStateCode {
    BLOCKED(0),
    READY(1),
    RETRY_WAITING(2),
    GROUP_RETRY_WAITING(3),
    RUNNING(4),
    PLANNED(5),
    GROUP_ERROR(6),
    SUCCESS(7),
    ERROR(8),
    CANCELED(9);

    public static final short BLOCKED_CODE = 0;
    public static final short READY_CODE = 1;
    public static final short RETRY_WAITING_CODE = 2;
    public static final short GROUP_RETRY_WAITING_CODE = 3;
    public static final short RUNNING_CODE = 4;
    public static final short PLANNED_CODE = 5;
    public static final short GROUP_RETRY_ERROR_CODE = 6;
    public static final short SUCCESS_CODE = 7;
    public static final short ERROR_CODE = 8;
    public static final short CANCELED_CODE = 9;
    private boolean error;
    private final short code;

    public static TaskStateCode[] canRunChildrenStates() {
        return new TaskStateCode[]{PLANNED, SUCCESS};
    }

    public static TaskStateCode[] canRunDownstreamStates() {
        return new TaskStateCode[]{SUCCESS};
    }

    public static TaskStateCode[] doneStates() {
        return new TaskStateCode[]{SUCCESS, GROUP_ERROR, ERROR, CANCELED};
    }

    public static TaskStateCode[] notDoneStates() {
        return new TaskStateCode[]{BLOCKED, READY, RETRY_WAITING, GROUP_RETRY_WAITING, RUNNING, PLANNED};
    }

    public static TaskStateCode[] progressingStates() {
        return new TaskStateCode[]{READY, RETRY_WAITING, GROUP_RETRY_WAITING, RUNNING, PLANNED};
    }

    public static TaskStateCode[] errorStates() {
        return new TaskStateCode[]{ERROR, GROUP_ERROR};
    }

    @JsonCreator
    public static TaskStateCode fromString(String name) {
        switch (name) {
            case "blocked": {
                return BLOCKED;
            }
            case "ready": {
                return READY;
            }
            case "retry_waiting": {
                return RETRY_WAITING;
            }
            case "group_retry_waiting": {
                return GROUP_RETRY_WAITING;
            }
            case "running": {
                return RUNNING;
            }
            case "planned": {
                return PLANNED;
            }
            case "group_error": {
                return GROUP_ERROR;
            }
            case "success": {
                return SUCCESS;
            }
            case "error": {
                return ERROR;
            }
            case "canceled": {
                return CANCELED;
            }
        }
        throw new IllegalStateException("Unknown task status name: " + name);
    }

    public static TaskStateCode of(int code) {
        switch (code) {
            case 0: {
                return BLOCKED;
            }
            case 1: {
                return READY;
            }
            case 2: {
                return RETRY_WAITING;
            }
            case 3: {
                return GROUP_RETRY_WAITING;
            }
            case 4: {
                return RUNNING;
            }
            case 5: {
                return PLANNED;
            }
            case 6: {
                return GROUP_ERROR;
            }
            case 7: {
                return SUCCESS;
            }
            case 8: {
                return ERROR;
            }
            case 9: {
                return CANCELED;
            }
        }
        throw new IllegalStateException("Unknown task status code");
    }

    private TaskStateCode(int code) {
        this.code = (short)code;
    }

    public short get() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    public boolean isError() {
        return Stream.of(TaskStateCode.errorStates()).anyMatch(errorState -> errorState == this);
    }
}

