/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.session.TaskRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableTaskRelation
extends TaskRelation {
    private final long id;
    private final Optional<Long> parentId;
    private final ImmutableList<Long> upstreams;

    private ImmutableTaskRelation(long id, Optional<Long> parentId, ImmutableList<Long> upstreams) {
        this.id = id;
        this.parentId = parentId;
        this.upstreams = upstreams;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="parentId")
    public Optional<Long> getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="upstreams")
    public ImmutableList<Long> getUpstreams() {
        return this.upstreams;
    }

    public final ImmutableTaskRelation withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableTaskRelation(value, this.parentId, this.upstreams);
    }

    public final ImmutableTaskRelation withParentId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.parentId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTaskRelation(this.id, (Optional<Long>)newValue, this.upstreams);
    }

    public final ImmutableTaskRelation withParentId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"parentId");
        if (this.parentId.equals((Object)value)) {
            return this;
        }
        return new ImmutableTaskRelation(this.id, (Optional<Long>)value, this.upstreams);
    }

    public final ImmutableTaskRelation withUpstreams(long ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Longs.asList((long[])elements));
        return new ImmutableTaskRelation(this.id, this.parentId, (ImmutableList<Long>)newValue);
    }

    public final ImmutableTaskRelation withUpstreams(Iterable<Long> elements) {
        if (this.upstreams == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTaskRelation(this.id, this.parentId, (ImmutableList<Long>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskRelation && this.equalTo((ImmutableTaskRelation)another);
    }

    private boolean equalTo(ImmutableTaskRelation another) {
        return this.id == another.id && this.parentId.equals(another.parentId) && this.upstreams.equals(another.upstreams);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + this.parentId.hashCode();
        h = h * 17 + this.upstreams.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskRelation").omitNullValues().add("id", this.id).add("parentId", this.parentId.orNull()).add("upstreams", this.upstreams).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaskRelation fromJson(Json json) {
        Builder builder = ImmutableTaskRelation.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        if (json.upstreams != null) {
            builder.addAllUpstreams(json.upstreams);
        }
        return builder.build();
    }

    public static ImmutableTaskRelation copyOf(TaskRelation instance) {
        if (instance instanceof ImmutableTaskRelation) {
            return (ImmutableTaskRelation)instance;
        }
        return ImmutableTaskRelation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        private long id;
        private Optional<Long> parentId = Optional.absent();
        private ImmutableList.Builder<Long> upstreams = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TaskRelation instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            Optional<Long> parentIdOptional = instance.getParentId();
            if (parentIdOptional.isPresent()) {
                this.parentId(parentIdOptional);
            }
            this.addAllUpstreams(instance.getUpstreams());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentId(long parentId) {
            this.parentId = Optional.of((Object)parentId);
            return this;
        }

        @JsonProperty(value="parentId")
        @CanIgnoreReturnValue
        public final Builder parentId(Optional<Long> parentId) {
            this.parentId = (Optional)Preconditions.checkNotNull(parentId, (Object)"parentId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUpstreams(long element) {
            this.upstreams.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUpstreams(long ... elements) {
            this.upstreams.addAll((Iterable)Longs.asList((long[])elements));
            return this;
        }

        @JsonProperty(value="upstreams")
        @CanIgnoreReturnValue
        public final Builder upstreams(Iterable<Long> elements) {
            this.upstreams = ImmutableList.builder();
            return this.addAllUpstreams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUpstreams(Iterable<Long> elements) {
            this.upstreams.addAll(elements);
            return this;
        }

        public ImmutableTaskRelation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskRelation(this.id, this.parentId, this.upstreams.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build TaskRelation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends TaskRelation {
        long id;
        boolean idIsSet;
        Optional<Long> parentId = Optional.absent();
        List<Long> upstreams = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="parentId")
        public void setParentId(Optional<Long> parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="upstreams")
        public void setUpstreams(List<Long> upstreams) {
            this.upstreams = upstreams;
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getParentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Long> getUpstreams() {
            throw new UnsupportedOperationException();
        }
    }
}

