/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.session.AttemptStateFlags;
import io.digdag.core.session.SessionAttempt;
import io.digdag.core.session.StoredSessionAttempt;
import io.digdag.core.session.StoredSessionAttemptImpl;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredSessionAttempt
extends StoredSessionAttemptImpl {
    private final long id;
    private final AttemptStateFlags stateFlags;
    private final long sessionId;
    private final int index;
    private final Instant createdAt;
    private final Optional<Instant> finishedAt;
    private final Optional<String> retryAttemptName;
    private final Optional<Long> workflowDefinitionId;
    private final ZoneId timeZone;
    private final Config params;

    private ImmutableStoredSessionAttempt(long id, AttemptStateFlags stateFlags, long sessionId, int index, Instant createdAt, Optional<Instant> finishedAt, Optional<String> retryAttemptName, Optional<Long> workflowDefinitionId, ZoneId timeZone, Config params) {
        this.id = id;
        this.stateFlags = stateFlags;
        this.sessionId = sessionId;
        this.index = index;
        this.createdAt = createdAt;
        this.finishedAt = finishedAt;
        this.retryAttemptName = retryAttemptName;
        this.workflowDefinitionId = workflowDefinitionId;
        this.timeZone = timeZone;
        this.params = params;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="stateFlags")
    public AttemptStateFlags getStateFlags() {
        return this.stateFlags;
    }

    @Override
    @JsonProperty(value="sessionId")
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="index")
    public int getIndex() {
        return this.index;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="finishedAt")
    public Optional<Instant> getFinishedAt() {
        return this.finishedAt;
    }

    @Override
    @JsonProperty(value="retryAttemptName")
    public Optional<String> getRetryAttemptName() {
        return this.retryAttemptName;
    }

    @Override
    @JsonProperty(value="workflowDefinitionId")
    public Optional<Long> getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    @Override
    @JsonProperty(value="timeZone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    @JsonProperty(value="params")
    public Config getParams() {
        return this.params;
    }

    public final ImmutableStoredSessionAttempt withId(long value) {
        if (this.id == value) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(value, this.stateFlags, this.sessionId, this.index, this.createdAt, this.finishedAt, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withStateFlags(AttemptStateFlags value) {
        if (this.stateFlags == value) {
            return this;
        }
        AttemptStateFlags newValue = (AttemptStateFlags)Preconditions.checkNotNull((Object)value, (Object)"stateFlags");
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, newValue, this.sessionId, this.index, this.createdAt, this.finishedAt, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withSessionId(long value) {
        if (this.sessionId == value) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, value, this.index, this.createdAt, this.finishedAt, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, value, this.createdAt, this.finishedAt, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, newValue, this.finishedAt, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withFinishedAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.finishedAt.isPresent() && this.finishedAt.get() == value) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, (Optional<Instant>)newValue, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withFinishedAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"finishedAt");
        if (!this.finishedAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.finishedAt.isPresent() && value.isPresent() && this.finishedAt.get() == value.get()) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, (Optional<Instant>)value, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withRetryAttemptName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAttemptName.equals((Object)newValue)) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, this.finishedAt, (Optional<String>)newValue, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withRetryAttemptName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAttemptName");
        if (this.retryAttemptName.equals((Object)value)) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, this.finishedAt, (Optional<String>)value, this.workflowDefinitionId, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withWorkflowDefinitionId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.workflowDefinitionId.equals((Object)newValue)) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, this.finishedAt, this.retryAttemptName, (Optional<Long>)newValue, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withWorkflowDefinitionId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"workflowDefinitionId");
        if (this.workflowDefinitionId.equals((Object)value)) {
            return this;
        }
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, this.finishedAt, this.retryAttemptName, (Optional<Long>)value, this.timeZone, this.params));
    }

    public final ImmutableStoredSessionAttempt withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, this.finishedAt, this.retryAttemptName, this.workflowDefinitionId, newValue, this.params));
    }

    public final ImmutableStoredSessionAttempt withParams(Config value) {
        if (this.params == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"params");
        return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, this.finishedAt, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredSessionAttempt && this.equalTo((ImmutableStoredSessionAttempt)another);
    }

    private boolean equalTo(ImmutableStoredSessionAttempt another) {
        return this.id == another.id && this.stateFlags.equals(another.stateFlags) && this.sessionId == another.sessionId && this.index == another.index && this.createdAt.equals(another.createdAt) && this.finishedAt.equals(another.finishedAt) && this.retryAttemptName.equals(another.retryAttemptName) && this.workflowDefinitionId.equals(another.workflowDefinitionId) && this.timeZone.equals(another.timeZone) && this.params.equals((Object)another.params);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + this.stateFlags.hashCode();
        h = h * 17 + Longs.hashCode((long)this.sessionId);
        h = h * 17 + this.index;
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.finishedAt.hashCode();
        h = h * 17 + this.retryAttemptName.hashCode();
        h = h * 17 + this.workflowDefinitionId.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        h = h * 17 + this.params.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredSessionAttempt").omitNullValues().add("id", this.id).add("stateFlags", (Object)this.stateFlags).add("sessionId", this.sessionId).add("index", this.index).add("createdAt", (Object)this.createdAt).add("finishedAt", this.finishedAt.orNull()).add("retryAttemptName", this.retryAttemptName.orNull()).add("workflowDefinitionId", this.workflowDefinitionId.orNull()).add("timeZone", (Object)this.timeZone).add("params", (Object)this.params).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredSessionAttempt fromJson(Json json) {
        Builder builder = ImmutableStoredSessionAttempt.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.stateFlags != null) {
            builder.stateFlags(json.stateFlags);
        }
        if (json.sessionIdIsSet) {
            builder.sessionId(json.sessionId);
        }
        if (json.indexIsSet) {
            builder.index(json.index);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.finishedAt != null) {
            builder.finishedAt(json.finishedAt);
        }
        if (json.retryAttemptName != null) {
            builder.retryAttemptName(json.retryAttemptName);
        }
        if (json.workflowDefinitionId != null) {
            builder.workflowDefinitionId(json.workflowDefinitionId);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        if (json.params != null) {
            builder.params(json.params);
        }
        return builder.build();
    }

    private static ImmutableStoredSessionAttempt validate(ImmutableStoredSessionAttempt instance) {
        instance.check();
        return instance;
    }

    public static ImmutableStoredSessionAttempt copyOf(StoredSessionAttemptImpl instance) {
        if (instance instanceof ImmutableStoredSessionAttempt) {
            return (ImmutableStoredSessionAttempt)instance;
        }
        return ImmutableStoredSessionAttempt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_STATE_FLAGS = 2L;
        private static final long INIT_BIT_SESSION_ID = 4L;
        private static final long INIT_BIT_INDEX = 8L;
        private static final long INIT_BIT_CREATED_AT = 16L;
        private static final long INIT_BIT_TIME_ZONE = 32L;
        private static final long INIT_BIT_PARAMS = 64L;
        private long initBits = 127L;
        private long id;
        @Nullable
        private AttemptStateFlags stateFlags;
        private long sessionId;
        private int index;
        @Nullable
        private Instant createdAt;
        private Optional<Instant> finishedAt = Optional.absent();
        private Optional<String> retryAttemptName = Optional.absent();
        private Optional<Long> workflowDefinitionId = Optional.absent();
        @Nullable
        private ZoneId timeZone;
        @Nullable
        private Config params;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionAttempt instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredSessionAttempt instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredSessionAttemptImpl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SessionAttempt instance;
            if (object instanceof SessionAttempt) {
                Optional<String> retryAttemptNameOptional;
                instance = (SessionAttempt)object;
                this.timeZone(instance.getTimeZone());
                Optional<Long> workflowDefinitionIdOptional = instance.getWorkflowDefinitionId();
                if (workflowDefinitionIdOptional.isPresent()) {
                    this.workflowDefinitionId(workflowDefinitionIdOptional);
                }
                if ((retryAttemptNameOptional = instance.getRetryAttemptName()).isPresent()) {
                    this.retryAttemptName(retryAttemptNameOptional);
                }
                this.params(instance.getParams());
            }
            if (object instanceof StoredSessionAttempt) {
                instance = (StoredSessionAttempt)object;
                this.createdAt(((StoredSessionAttempt)instance).getCreatedAt());
                this.index(((StoredSessionAttempt)instance).getIndex());
                this.id(((StoredSessionAttempt)instance).getId());
                this.sessionId(((StoredSessionAttempt)instance).getSessionId());
                this.stateFlags(((StoredSessionAttempt)instance).getStateFlags());
                Optional<Instant> finishedAtOptional = ((StoredSessionAttempt)instance).getFinishedAt();
                if (finishedAtOptional.isPresent()) {
                    this.finishedAt(finishedAtOptional);
                }
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="stateFlags")
        @CanIgnoreReturnValue
        public final Builder stateFlags(AttemptStateFlags stateFlags) {
            this.stateFlags = (AttemptStateFlags)Preconditions.checkNotNull((Object)stateFlags, (Object)"stateFlags");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="sessionId")
        @CanIgnoreReturnValue
        public final Builder sessionId(long sessionId) {
            this.sessionId = sessionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = Optional.of((Object)finishedAt);
            return this;
        }

        @JsonProperty(value="finishedAt")
        @CanIgnoreReturnValue
        public final Builder finishedAt(Optional<Instant> finishedAt) {
            this.finishedAt = (Optional)Preconditions.checkNotNull(finishedAt, (Object)"finishedAt");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryAttemptName(String retryAttemptName) {
            this.retryAttemptName = Optional.of((Object)retryAttemptName);
            return this;
        }

        @JsonProperty(value="retryAttemptName")
        @CanIgnoreReturnValue
        public final Builder retryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = (Optional)Preconditions.checkNotNull(retryAttemptName, (Object)"retryAttemptName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = Optional.of((Object)workflowDefinitionId);
            return this;
        }

        @JsonProperty(value="workflowDefinitionId")
        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(Optional<Long> workflowDefinitionId) {
            this.workflowDefinitionId = (Optional)Preconditions.checkNotNull(workflowDefinitionId, (Object)"workflowDefinitionId");
            return this;
        }

        @JsonProperty(value="timeZone")
        @CanIgnoreReturnValue
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="params")
        @CanIgnoreReturnValue
        public final Builder params(Config params) {
            this.params = (Config)Preconditions.checkNotNull((Object)params, (Object)"params");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableStoredSessionAttempt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableStoredSessionAttempt.validate(new ImmutableStoredSessionAttempt(this.id, this.stateFlags, this.sessionId, this.index, this.createdAt, this.finishedAt, this.retryAttemptName, this.workflowDefinitionId, this.timeZone, this.params));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stateFlags");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sessionId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("timeZone");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("params");
            }
            return "Cannot build StoredSessionAttempt, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredSessionAttemptImpl {
        long id;
        boolean idIsSet;
        @Nullable
        AttemptStateFlags stateFlags;
        long sessionId;
        boolean sessionIdIsSet;
        int index;
        boolean indexIsSet;
        @Nullable
        Instant createdAt;
        Optional<Instant> finishedAt = Optional.absent();
        Optional<String> retryAttemptName = Optional.absent();
        Optional<Long> workflowDefinitionId = Optional.absent();
        @Nullable
        ZoneId timeZone;
        @Nullable
        Config params;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="stateFlags")
        public void setStateFlags(AttemptStateFlags stateFlags) {
            this.stateFlags = stateFlags;
        }

        @JsonProperty(value="sessionId")
        public void setSessionId(long sessionId) {
            this.sessionId = sessionId;
            this.sessionIdIsSet = true;
        }

        @JsonProperty(value="index")
        public void setIndex(int index) {
            this.index = index;
            this.indexIsSet = true;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="finishedAt")
        public void setFinishedAt(Optional<Instant> finishedAt) {
            this.finishedAt = finishedAt;
        }

        @JsonProperty(value="retryAttemptName")
        public void setRetryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = retryAttemptName;
        }

        @JsonProperty(value="workflowDefinitionId")
        public void setWorkflowDefinitionId(Optional<Long> workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
        }

        @JsonProperty(value="timeZone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @JsonProperty(value="params")
        public void setParams(Config params) {
            this.params = params;
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AttemptStateFlags getStateFlags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSessionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getFinishedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRetryAttemptName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getWorkflowDefinitionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getParams() {
            throw new UnsupportedOperationException();
        }
    }
}

