/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigKey;
import io.digdag.core.session.ResumingTask;
import io.digdag.core.workflow.TaskConfig;
import io.digdag.spi.TaskReport;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableResumingTask
extends ResumingTask {
    private final long sourceTaskId;
    private final String fullName;
    private final TaskConfig config;
    private final Instant updatedAt;
    private final Config subtaskConfig;
    private final Config exportParams;
    private final ImmutableList<ConfigKey> resetStoreParams;
    private final Config storeParams;
    private final TaskReport report;
    private final Config error;

    private ImmutableResumingTask(long sourceTaskId, String fullName, TaskConfig config, Instant updatedAt, Config subtaskConfig, Config exportParams, ImmutableList<ConfigKey> resetStoreParams, Config storeParams, TaskReport report, Config error) {
        this.sourceTaskId = sourceTaskId;
        this.fullName = fullName;
        this.config = config;
        this.updatedAt = updatedAt;
        this.subtaskConfig = subtaskConfig;
        this.exportParams = exportParams;
        this.resetStoreParams = resetStoreParams;
        this.storeParams = storeParams;
        this.report = report;
        this.error = error;
    }

    @Override
    @JsonProperty(value="sourceTaskId")
    public long getSourceTaskId() {
        return this.sourceTaskId;
    }

    @Override
    @JsonProperty(value="fullName")
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @JsonProperty(value="config")
    public TaskConfig getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="subtaskConfig")
    public Config getSubtaskConfig() {
        return this.subtaskConfig;
    }

    @Override
    @JsonProperty(value="exportParams")
    public Config getExportParams() {
        return this.exportParams;
    }

    @JsonProperty(value="resetStoreParams")
    public ImmutableList<ConfigKey> getResetStoreParams() {
        return this.resetStoreParams;
    }

    @Override
    @JsonProperty(value="storeParams")
    public Config getStoreParams() {
        return this.storeParams;
    }

    @Override
    @JsonProperty(value="report")
    public TaskReport getReport() {
        return this.report;
    }

    @Override
    @JsonProperty(value="error")
    public Config getError() {
        return this.error;
    }

    public final ImmutableResumingTask withSourceTaskId(long value) {
        if (this.sourceTaskId == value) {
            return this;
        }
        return new ImmutableResumingTask(value, this.fullName, this.config, this.updatedAt, this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error);
    }

    public final ImmutableResumingTask withFullName(String value) {
        if (this.fullName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fullName");
        return new ImmutableResumingTask(this.sourceTaskId, newValue, this.config, this.updatedAt, this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error);
    }

    public final ImmutableResumingTask withConfig(TaskConfig value) {
        if (this.config == value) {
            return this;
        }
        TaskConfig newValue = (TaskConfig)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, newValue, this.updatedAt, this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error);
    }

    public final ImmutableResumingTask withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, newValue, this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error);
    }

    public final ImmutableResumingTask withSubtaskConfig(Config value) {
        if (this.subtaskConfig == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"subtaskConfig");
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, this.updatedAt, newValue, this.exportParams, this.resetStoreParams, this.storeParams, this.report, this.error);
    }

    public final ImmutableResumingTask withExportParams(Config value) {
        if (this.exportParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"exportParams");
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, this.updatedAt, this.subtaskConfig, newValue, this.resetStoreParams, this.storeParams, this.report, this.error);
    }

    public final ImmutableResumingTask withResetStoreParams(ConfigKey ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, this.updatedAt, this.subtaskConfig, this.exportParams, (ImmutableList<ConfigKey>)newValue, this.storeParams, this.report, this.error);
    }

    public final ImmutableResumingTask withResetStoreParams(Iterable<? extends ConfigKey> elements) {
        if (this.resetStoreParams == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, this.updatedAt, this.subtaskConfig, this.exportParams, (ImmutableList<ConfigKey>)newValue, this.storeParams, this.report, this.error);
    }

    public final ImmutableResumingTask withStoreParams(Config value) {
        if (this.storeParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"storeParams");
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, this.updatedAt, this.subtaskConfig, this.exportParams, this.resetStoreParams, newValue, this.report, this.error);
    }

    public final ImmutableResumingTask withReport(TaskReport value) {
        if (this.report == value) {
            return this;
        }
        TaskReport newValue = (TaskReport)Preconditions.checkNotNull((Object)value, (Object)"report");
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, this.updatedAt, this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, newValue, this.error);
    }

    public final ImmutableResumingTask withError(Config value) {
        if (this.error == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"error");
        return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, this.updatedAt, this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, this.report, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResumingTask && this.equalTo((ImmutableResumingTask)another);
    }

    private boolean equalTo(ImmutableResumingTask another) {
        return this.sourceTaskId == another.sourceTaskId && this.fullName.equals(another.fullName) && this.config.equals(another.config) && this.updatedAt.equals(another.updatedAt) && this.subtaskConfig.equals((Object)another.subtaskConfig) && this.exportParams.equals((Object)another.exportParams) && this.resetStoreParams.equals(another.resetStoreParams) && this.storeParams.equals((Object)another.storeParams) && this.report.equals(another.report) && this.error.equals((Object)another.error);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.sourceTaskId);
        h = h * 17 + this.fullName.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        h = h * 17 + this.subtaskConfig.hashCode();
        h = h * 17 + this.exportParams.hashCode();
        h = h * 17 + this.resetStoreParams.hashCode();
        h = h * 17 + this.storeParams.hashCode();
        h = h * 17 + this.report.hashCode();
        h = h * 17 + this.error.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ResumingTask").omitNullValues().add("sourceTaskId", this.sourceTaskId).add("fullName", (Object)this.fullName).add("config", (Object)this.config).add("updatedAt", (Object)this.updatedAt).add("subtaskConfig", (Object)this.subtaskConfig).add("exportParams", (Object)this.exportParams).add("resetStoreParams", this.resetStoreParams).add("storeParams", (Object)this.storeParams).add("report", (Object)this.report).add("error", (Object)this.error).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableResumingTask fromJson(Json json) {
        Builder builder = ImmutableResumingTask.builder();
        if (json.sourceTaskIdIsSet) {
            builder.sourceTaskId(json.sourceTaskId);
        }
        if (json.fullName != null) {
            builder.fullName(json.fullName);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.subtaskConfig != null) {
            builder.subtaskConfig(json.subtaskConfig);
        }
        if (json.exportParams != null) {
            builder.exportParams(json.exportParams);
        }
        if (json.resetStoreParams != null) {
            builder.addAllResetStoreParams(json.resetStoreParams);
        }
        if (json.storeParams != null) {
            builder.storeParams(json.storeParams);
        }
        if (json.report != null) {
            builder.report(json.report);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        return builder.build();
    }

    public static ImmutableResumingTask copyOf(ResumingTask instance) {
        if (instance instanceof ImmutableResumingTask) {
            return (ImmutableResumingTask)instance;
        }
        return ImmutableResumingTask.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_TASK_ID = 1L;
        private static final long INIT_BIT_FULL_NAME = 2L;
        private static final long INIT_BIT_CONFIG = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_SUBTASK_CONFIG = 16L;
        private static final long INIT_BIT_EXPORT_PARAMS = 32L;
        private static final long INIT_BIT_STORE_PARAMS = 64L;
        private static final long INIT_BIT_REPORT = 128L;
        private static final long INIT_BIT_ERROR = 256L;
        private long initBits = 511L;
        private long sourceTaskId;
        @Nullable
        private String fullName;
        @Nullable
        private TaskConfig config;
        @Nullable
        private Instant updatedAt;
        @Nullable
        private Config subtaskConfig;
        @Nullable
        private Config exportParams;
        private ImmutableList.Builder<ConfigKey> resetStoreParams = ImmutableList.builder();
        @Nullable
        private Config storeParams;
        @Nullable
        private TaskReport report;
        @Nullable
        private Config error;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ResumingTask instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.sourceTaskId(instance.getSourceTaskId());
            this.fullName(instance.getFullName());
            this.config(instance.getConfig());
            this.updatedAt(instance.getUpdatedAt());
            this.subtaskConfig(instance.getSubtaskConfig());
            this.exportParams(instance.getExportParams());
            this.addAllResetStoreParams(instance.getResetStoreParams());
            this.storeParams(instance.getStoreParams());
            this.report(instance.getReport());
            this.error(instance.getError());
            return this;
        }

        @JsonProperty(value="sourceTaskId")
        @CanIgnoreReturnValue
        public final Builder sourceTaskId(long sourceTaskId) {
            this.sourceTaskId = sourceTaskId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="fullName")
        @CanIgnoreReturnValue
        public final Builder fullName(String fullName) {
            this.fullName = (String)Preconditions.checkNotNull((Object)fullName, (Object)"fullName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(TaskConfig config) {
            this.config = (TaskConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="updatedAt")
        @CanIgnoreReturnValue
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="subtaskConfig")
        @CanIgnoreReturnValue
        public final Builder subtaskConfig(Config subtaskConfig) {
            this.subtaskConfig = (Config)Preconditions.checkNotNull((Object)subtaskConfig, (Object)"subtaskConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="exportParams")
        @CanIgnoreReturnValue
        public final Builder exportParams(Config exportParams) {
            this.exportParams = (Config)Preconditions.checkNotNull((Object)exportParams, (Object)"exportParams");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResetStoreParams(ConfigKey element) {
            this.resetStoreParams.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResetStoreParams(ConfigKey ... elements) {
            this.resetStoreParams.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="resetStoreParams")
        @CanIgnoreReturnValue
        public final Builder resetStoreParams(Iterable<? extends ConfigKey> elements) {
            this.resetStoreParams = ImmutableList.builder();
            return this.addAllResetStoreParams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllResetStoreParams(Iterable<? extends ConfigKey> elements) {
            this.resetStoreParams.addAll(elements);
            return this;
        }

        @JsonProperty(value="storeParams")
        @CanIgnoreReturnValue
        public final Builder storeParams(Config storeParams) {
            this.storeParams = (Config)Preconditions.checkNotNull((Object)storeParams, (Object)"storeParams");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="report")
        @CanIgnoreReturnValue
        public final Builder report(TaskReport report) {
            this.report = (TaskReport)Preconditions.checkNotNull((Object)report, (Object)"report");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="error")
        @CanIgnoreReturnValue
        public final Builder error(Config error) {
            this.error = (Config)Preconditions.checkNotNull((Object)error, (Object)"error");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public ImmutableResumingTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResumingTask(this.sourceTaskId, this.fullName, this.config, this.updatedAt, this.subtaskConfig, this.exportParams, this.resetStoreParams.build(), this.storeParams, this.report, this.error);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceTaskId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fullName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("subtaskConfig");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("exportParams");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("storeParams");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("report");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("error");
            }
            return "Cannot build ResumingTask, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ResumingTask {
        long sourceTaskId;
        boolean sourceTaskIdIsSet;
        @Nullable
        String fullName;
        @Nullable
        TaskConfig config;
        @Nullable
        Instant updatedAt;
        @Nullable
        Config subtaskConfig;
        @Nullable
        Config exportParams;
        List<ConfigKey> resetStoreParams = ImmutableList.of();
        @Nullable
        Config storeParams;
        @Nullable
        TaskReport report;
        @Nullable
        Config error;

        Json() {
        }

        @JsonProperty(value="sourceTaskId")
        public void setSourceTaskId(long sourceTaskId) {
            this.sourceTaskId = sourceTaskId;
            this.sourceTaskIdIsSet = true;
        }

        @JsonProperty(value="fullName")
        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        @JsonProperty(value="config")
        public void setConfig(TaskConfig config) {
            this.config = config;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="subtaskConfig")
        public void setSubtaskConfig(Config subtaskConfig) {
            this.subtaskConfig = subtaskConfig;
        }

        @JsonProperty(value="exportParams")
        public void setExportParams(Config exportParams) {
            this.exportParams = exportParams;
        }

        @JsonProperty(value="resetStoreParams")
        public void setResetStoreParams(List<ConfigKey> resetStoreParams) {
            this.resetStoreParams = resetStoreParams;
        }

        @JsonProperty(value="storeParams")
        public void setStoreParams(Config storeParams) {
            this.storeParams = storeParams;
        }

        @JsonProperty(value="report")
        public void setReport(TaskReport report) {
            this.report = report;
        }

        @JsonProperty(value="error")
        public void setError(Config error) {
            this.error = error;
        }

        @Override
        public long getSourceTaskId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFullName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskConfig getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getSubtaskConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getExportParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ConfigKey> getResetStoreParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getStoreParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskReport getReport() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getError() {
            throw new UnsupportedOperationException();
        }
    }
}

