/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.schedule;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.schedule.Schedule;
import io.digdag.core.schedule.StoredSchedule;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredSchedule
extends StoredSchedule {
    private final int id;
    private final int projectId;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Optional<Instant> disabledAt;
    private final Optional<Instant> lastSessionTime;
    private final String workflowName;
    private final long workflowDefinitionId;
    private final Instant nextRunTime;
    private final Instant nextScheduleTime;

    private ImmutableStoredSchedule(int id, int projectId, Instant createdAt, Instant updatedAt, Optional<Instant> disabledAt, Optional<Instant> lastSessionTime, String workflowName, long workflowDefinitionId, Instant nextRunTime, Instant nextScheduleTime) {
        this.id = id;
        this.projectId = projectId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.disabledAt = disabledAt;
        this.lastSessionTime = lastSessionTime;
        this.workflowName = workflowName;
        this.workflowDefinitionId = workflowDefinitionId;
        this.nextRunTime = nextRunTime;
        this.nextScheduleTime = nextScheduleTime;
    }

    @Override
    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="projectId")
    public int getProjectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="disabledAt")
    public Optional<Instant> getDisabledAt() {
        return this.disabledAt;
    }

    @Override
    @JsonProperty(value="lastSessionTime")
    public Optional<Instant> getLastSessionTime() {
        return this.lastSessionTime;
    }

    @Override
    @JsonProperty(value="workflowName")
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="workflowDefinitionId")
    public long getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    @Override
    @JsonProperty(value="nextRunTime")
    public Instant getNextRunTime() {
        return this.nextRunTime;
    }

    @Override
    @JsonProperty(value="nextScheduleTime")
    public Instant getNextScheduleTime() {
        return this.nextScheduleTime;
    }

    public final ImmutableStoredSchedule withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableStoredSchedule(value, this.projectId, this.createdAt, this.updatedAt, this.disabledAt, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return new ImmutableStoredSchedule(this.id, value, this.createdAt, this.updatedAt, this.disabledAt, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableStoredSchedule(this.id, this.projectId, newValue, this.updatedAt, this.disabledAt, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, newValue, this.disabledAt, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withDisabledAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.disabledAt.isPresent() && this.disabledAt.get() == value) {
            return this;
        }
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, (Optional<Instant>)newValue, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withDisabledAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"disabledAt");
        if (!this.disabledAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.disabledAt.isPresent() && value.isPresent() && this.disabledAt.get() == value.get()) {
            return this;
        }
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, (Optional<Instant>)value, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withLastSessionTime(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.lastSessionTime.isPresent() && this.lastSessionTime.get() == value) {
            return this;
        }
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, this.disabledAt, (Optional<Instant>)newValue, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withLastSessionTime(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"lastSessionTime");
        if (!this.lastSessionTime.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.lastSessionTime.isPresent() && value.isPresent() && this.lastSessionTime.get() == value.get()) {
            return this;
        }
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, this.disabledAt, (Optional<Instant>)value, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, this.disabledAt, this.lastSessionTime, newValue, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withWorkflowDefinitionId(long value) {
        if (this.workflowDefinitionId == value) {
            return this;
        }
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, this.disabledAt, this.lastSessionTime, this.workflowName, value, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withNextRunTime(Instant value) {
        if (this.nextRunTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"nextRunTime");
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, this.disabledAt, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, newValue, this.nextScheduleTime);
    }

    public final ImmutableStoredSchedule withNextScheduleTime(Instant value) {
        if (this.nextScheduleTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"nextScheduleTime");
        return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, this.disabledAt, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, this.nextRunTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredSchedule && this.equalTo((ImmutableStoredSchedule)another);
    }

    private boolean equalTo(ImmutableStoredSchedule another) {
        return this.id == another.id && this.projectId == another.projectId && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.disabledAt.equals(another.disabledAt) && this.lastSessionTime.equals(another.lastSessionTime) && this.workflowName.equals(another.workflowName) && this.workflowDefinitionId == another.workflowDefinitionId && this.nextRunTime.equals(another.nextRunTime) && this.nextScheduleTime.equals(another.nextScheduleTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id;
        h = h * 17 + this.projectId;
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        h = h * 17 + this.disabledAt.hashCode();
        h = h * 17 + this.lastSessionTime.hashCode();
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + Longs.hashCode((long)this.workflowDefinitionId);
        h = h * 17 + this.nextRunTime.hashCode();
        h = h * 17 + this.nextScheduleTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredSchedule").omitNullValues().add("id", this.id).add("projectId", this.projectId).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).add("disabledAt", this.disabledAt.orNull()).add("lastSessionTime", this.lastSessionTime.orNull()).add("workflowName", (Object)this.workflowName).add("workflowDefinitionId", this.workflowDefinitionId).add("nextRunTime", (Object)this.nextRunTime).add("nextScheduleTime", (Object)this.nextScheduleTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredSchedule fromJson(Json json) {
        Builder builder = ImmutableStoredSchedule.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.projectIdIsSet) {
            builder.projectId(json.projectId);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.disabledAt != null) {
            builder.disabledAt(json.disabledAt);
        }
        if (json.lastSessionTime != null) {
            builder.lastSessionTime(json.lastSessionTime);
        }
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.workflowDefinitionIdIsSet) {
            builder.workflowDefinitionId(json.workflowDefinitionId);
        }
        if (json.nextRunTime != null) {
            builder.nextRunTime(json.nextRunTime);
        }
        if (json.nextScheduleTime != null) {
            builder.nextScheduleTime(json.nextScheduleTime);
        }
        return builder.build();
    }

    public static ImmutableStoredSchedule copyOf(StoredSchedule instance) {
        if (instance instanceof ImmutableStoredSchedule) {
            return (ImmutableStoredSchedule)instance;
        }
        return ImmutableStoredSchedule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PROJECT_ID = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_WORKFLOW_NAME = 16L;
        private static final long INIT_BIT_WORKFLOW_DEFINITION_ID = 32L;
        private static final long INIT_BIT_NEXT_RUN_TIME = 64L;
        private static final long INIT_BIT_NEXT_SCHEDULE_TIME = 128L;
        private long initBits = 255L;
        private int id;
        private int projectId;
        @Nullable
        private Instant createdAt;
        @Nullable
        private Instant updatedAt;
        private Optional<Instant> disabledAt = Optional.absent();
        private Optional<Instant> lastSessionTime = Optional.absent();
        @Nullable
        private String workflowName;
        private long workflowDefinitionId;
        @Nullable
        private Instant nextRunTime;
        @Nullable
        private Instant nextScheduleTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredSchedule instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Schedule instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Schedule instance;
            if (object instanceof StoredSchedule) {
                instance = (StoredSchedule)object;
                this.createdAt(((StoredSchedule)instance).getCreatedAt());
                Optional<Instant> lastSessionTimeOptional = ((StoredSchedule)instance).getLastSessionTime();
                if (lastSessionTimeOptional.isPresent()) {
                    this.lastSessionTime(lastSessionTimeOptional);
                }
                this.id(((StoredSchedule)instance).getId());
                this.projectId(((StoredSchedule)instance).getProjectId());
                Optional<Instant> disabledAtOptional = ((StoredSchedule)instance).getDisabledAt();
                if (disabledAtOptional.isPresent()) {
                    this.disabledAt(disabledAtOptional);
                }
                this.updatedAt(((StoredSchedule)instance).getUpdatedAt());
            }
            if (object instanceof Schedule) {
                instance = (Schedule)object;
                this.workflowDefinitionId(instance.getWorkflowDefinitionId());
                this.workflowName(instance.getWorkflowName());
                this.nextRunTime(instance.getNextRunTime());
                this.nextScheduleTime(instance.getNextScheduleTime());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="projectId")
        @CanIgnoreReturnValue
        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="updatedAt")
        @CanIgnoreReturnValue
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder disabledAt(Instant disabledAt) {
            this.disabledAt = Optional.of((Object)disabledAt);
            return this;
        }

        @JsonProperty(value="disabledAt")
        @CanIgnoreReturnValue
        public final Builder disabledAt(Optional<Instant> disabledAt) {
            this.disabledAt = (Optional)Preconditions.checkNotNull(disabledAt, (Object)"disabledAt");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastSessionTime(Instant lastSessionTime) {
            this.lastSessionTime = Optional.of((Object)lastSessionTime);
            return this;
        }

        @JsonProperty(value="lastSessionTime")
        @CanIgnoreReturnValue
        public final Builder lastSessionTime(Optional<Instant> lastSessionTime) {
            this.lastSessionTime = (Optional)Preconditions.checkNotNull(lastSessionTime, (Object)"lastSessionTime");
            return this;
        }

        @JsonProperty(value="workflowName")
        @CanIgnoreReturnValue
        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="workflowDefinitionId")
        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="nextRunTime")
        @CanIgnoreReturnValue
        public final Builder nextRunTime(Instant nextRunTime) {
            this.nextRunTime = (Instant)Preconditions.checkNotNull((Object)nextRunTime, (Object)"nextRunTime");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="nextScheduleTime")
        @CanIgnoreReturnValue
        public final Builder nextScheduleTime(Instant nextScheduleTime) {
            this.nextScheduleTime = (Instant)Preconditions.checkNotNull((Object)nextScheduleTime, (Object)"nextScheduleTime");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableStoredSchedule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoredSchedule(this.id, this.projectId, this.createdAt, this.updatedAt, this.disabledAt, this.lastSessionTime, this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("workflowDefinitionId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("nextRunTime");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("nextScheduleTime");
            }
            return "Cannot build StoredSchedule, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredSchedule {
        int id;
        boolean idIsSet;
        int projectId;
        boolean projectIdIsSet;
        @Nullable
        Instant createdAt;
        @Nullable
        Instant updatedAt;
        Optional<Instant> disabledAt = Optional.absent();
        Optional<Instant> lastSessionTime = Optional.absent();
        @Nullable
        String workflowName;
        long workflowDefinitionId;
        boolean workflowDefinitionIdIsSet;
        @Nullable
        Instant nextRunTime;
        @Nullable
        Instant nextScheduleTime;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(int id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="projectId")
        public void setProjectId(int projectId) {
            this.projectId = projectId;
            this.projectIdIsSet = true;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="disabledAt")
        public void setDisabledAt(Optional<Instant> disabledAt) {
            this.disabledAt = disabledAt;
        }

        @JsonProperty(value="lastSessionTime")
        public void setLastSessionTime(Optional<Instant> lastSessionTime) {
            this.lastSessionTime = lastSessionTime;
        }

        @JsonProperty(value="workflowName")
        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="workflowDefinitionId")
        public void setWorkflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
            this.workflowDefinitionIdIsSet = true;
        }

        @JsonProperty(value="nextRunTime")
        public void setNextRunTime(Instant nextRunTime) {
            this.nextRunTime = nextRunTime;
        }

        @JsonProperty(value="nextScheduleTime")
        public void setNextScheduleTime(Instant nextScheduleTime) {
            this.nextScheduleTime = nextScheduleTime;
        }

        @Override
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProjectId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getDisabledAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getLastSessionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWorkflowDefinitionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getNextRunTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getNextScheduleTime() {
            throw new UnsupportedOperationException();
        }
    }
}

