/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.repository;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.repository.Project;
import io.digdag.core.repository.StoredProject;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredProject
extends StoredProject {
    private final int id;
    private final int siteId;
    private final Instant createdAt;
    private final Optional<Instant> deletedAt;
    private final String name;

    private ImmutableStoredProject(int id, int siteId, Instant createdAt, Optional<Instant> deletedAt, String name) {
        this.id = id;
        this.siteId = siteId;
        this.createdAt = createdAt;
        this.deletedAt = deletedAt;
        this.name = name;
    }

    @Override
    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="siteId")
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="deletedAt")
    public Optional<Instant> getDeletedAt() {
        return this.deletedAt;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public final ImmutableStoredProject withId(int value) {
        if (this.id == value) {
            return this;
        }
        return ImmutableStoredProject.validate(new ImmutableStoredProject(value, this.siteId, this.createdAt, this.deletedAt, this.name));
    }

    public final ImmutableStoredProject withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return ImmutableStoredProject.validate(new ImmutableStoredProject(this.id, value, this.createdAt, this.deletedAt, this.name));
    }

    public final ImmutableStoredProject withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return ImmutableStoredProject.validate(new ImmutableStoredProject(this.id, this.siteId, newValue, this.deletedAt, this.name));
    }

    public final ImmutableStoredProject withDeletedAt(Instant value) {
        Optional newValue = Optional.of((Object)value);
        if (this.deletedAt.isPresent() && this.deletedAt.get() == value) {
            return this;
        }
        return ImmutableStoredProject.validate(new ImmutableStoredProject(this.id, this.siteId, this.createdAt, (Optional<Instant>)newValue, this.name));
    }

    public final ImmutableStoredProject withDeletedAt(Optional<Instant> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"deletedAt");
        if (!this.deletedAt.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.deletedAt.isPresent() && value.isPresent() && this.deletedAt.get() == value.get()) {
            return this;
        }
        return ImmutableStoredProject.validate(new ImmutableStoredProject(this.id, this.siteId, this.createdAt, (Optional<Instant>)value, this.name));
    }

    public final ImmutableStoredProject withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return ImmutableStoredProject.validate(new ImmutableStoredProject(this.id, this.siteId, this.createdAt, this.deletedAt, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredProject && this.equalTo((ImmutableStoredProject)another);
    }

    private boolean equalTo(ImmutableStoredProject another) {
        return this.id == another.id && this.siteId == another.siteId && this.createdAt.equals(another.createdAt) && this.deletedAt.equals(another.deletedAt) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id;
        h = h * 17 + this.siteId;
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.deletedAt.hashCode();
        h = h * 17 + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredProject").omitNullValues().add("id", this.id).add("siteId", this.siteId).add("createdAt", (Object)this.createdAt).add("deletedAt", this.deletedAt.orNull()).add("name", (Object)this.name).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredProject fromJson(Json json) {
        Builder builder = ImmutableStoredProject.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.siteIdIsSet) {
            builder.siteId(json.siteId);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.deletedAt != null) {
            builder.deletedAt(json.deletedAt);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    private static ImmutableStoredProject validate(ImmutableStoredProject instance) {
        instance.check();
        return instance;
    }

    public static ImmutableStoredProject copyOf(StoredProject instance) {
        if (instance instanceof ImmutableStoredProject) {
            return (ImmutableStoredProject)instance;
        }
        return ImmutableStoredProject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SITE_ID = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private long initBits = 15L;
        private int id;
        private int siteId;
        @Nullable
        private Instant createdAt;
        private Optional<Instant> deletedAt = Optional.absent();
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredProject instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Project instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Project instance;
            if (object instanceof StoredProject) {
                instance = (StoredProject)object;
                this.createdAt(((StoredProject)instance).getCreatedAt());
                this.siteId(((StoredProject)instance).getSiteId());
                Optional<Instant> deletedAtOptional = ((StoredProject)instance).getDeletedAt();
                if (deletedAtOptional.isPresent()) {
                    this.deletedAt(deletedAtOptional);
                }
                this.id(((StoredProject)instance).getId());
            }
            if (object instanceof Project) {
                instance = (Project)object;
                this.name(instance.getName());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="siteId")
        @CanIgnoreReturnValue
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = Optional.of((Object)deletedAt);
            return this;
        }

        @JsonProperty(value="deletedAt")
        @CanIgnoreReturnValue
        public final Builder deletedAt(Optional<Instant> deletedAt) {
            this.deletedAt = (Optional)Preconditions.checkNotNull(deletedAt, (Object)"deletedAt");
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableStoredProject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableStoredProject.validate(new ImmutableStoredProject(this.id, this.siteId, this.createdAt, this.deletedAt, this.name));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build StoredProject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredProject {
        int id;
        boolean idIsSet;
        int siteId;
        boolean siteIdIsSet;
        @Nullable
        Instant createdAt;
        Optional<Instant> deletedAt = Optional.absent();
        @Nullable
        String name;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(int id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="siteId")
        public void setSiteId(int siteId) {
            this.siteId = siteId;
            this.siteIdIsSet = true;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="deletedAt")
        public void setDeletedAt(Optional<Instant> deletedAt) {
            this.deletedAt = deletedAt;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public int getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSiteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getDeletedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }
    }
}

